/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter;

import atm.bloodworkxgaming.serverstarter.InternetManager;
import atm.bloodworkxgaming.serverstarter.OSUtil;
import atm.bloodworkxgaming.serverstarter.ServerStarter;
import atm.bloodworkxgaming.serverstarter.config.ConfigFile;
import atm.bloodworkxgaming.serverstarter.logger.PrimitiveLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Latm/bloodworkxgaming/serverstarter/ForgeManager;", "", "configFile", "Latm/bloodworkxgaming/serverstarter/config/ConfigFile;", "(Latm/bloodworkxgaming/serverstarter/config/ConfigFile;)V", "checkEULA", "", "basepath", "", "handleServer", "installForge", "basePath", "forgeVersion", "mcVersion", "installSpongeBootstrapper", "startServer", "serverstarter"})
public final class ForgeManager {
    private final ConfigFile configFile;

    public final void handleServer() {
        boolean shouldRestart;
        long l;
        ArrayList<LocalDateTime> startTimes = new ArrayList<LocalDateTime>();
        String timerString = this.configFile.getLaunch().getCrashTimer();
        try {
            long l2;
            int n;
            int n2;
            if (StringsKt.endsWith$default(timerString, "h", false, 2, null)) {
                String string = timerString;
                n2 = 0;
                n = timerString.length() - 1;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                l2 = Long.parseLong(string3) * (long)60 * (long)60;
            } else if (StringsKt.endsWith$default(timerString, "min", false, 2, null)) {
                String string = timerString;
                n2 = 0;
                n = timerString.length() - 3;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                l2 = Long.parseLong(string5) * (long)60;
            } else if (StringsKt.endsWith$default(timerString, "s", false, 2, null)) {
                String string = timerString;
                n2 = 0;
                n = timerString.length() - 1;
                String string6 = string;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                l2 = Long.parseLong(string7);
            } else {
                l2 = Long.parseLong(timerString);
            }
            l = l2;
        }
        catch (NumberFormatException e) {
            ServerStarter.Companion.getLOGGER().error("Invalid crash time format given", e);
            l = -1L;
        }
        long crashTimer = l;
        do {
            LocalDateTime now = LocalDateTime.now();
            startTimes.removeIf(new Predicate<LocalDateTime>(crashTimer, now){
                final /* synthetic */ long $crashTimer;
                final /* synthetic */ LocalDateTime $now;

                public final boolean test(@NotNull LocalDateTime start) {
                    Intrinsics.checkParameterIsNotNull(start, "start");
                    return start.until(this.$now, ChronoUnit.SECONDS) > this.$crashTimer;
                }
                {
                    this.$crashTimer = l;
                    this.$now = localDateTime;
                }
            });
            this.startServer();
            startTimes.add(now);
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Server has been stopped, it has started " + startTimes.size() + " times in " + this.configFile.getLaunch().getCrashTimer(), false, 2, null);
            boolean bl = shouldRestart = this.configFile.getLaunch().getAutoRestart() && startTimes.size() <= this.configFile.getLaunch().getCrashLimit();
            if (!shouldRestart) continue;
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Restarting server in 10 seconds, press ctrl+c to stop", false, 2, null);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (shouldRestart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEULA(String basepath) {
        block11: {
            try {
                List<String> lines;
                File eulaFile = new File(basepath + "eula.txt");
                if (eulaFile.exists()) {
                    List<String> list = FileUtils.readLines(eulaFile, "utf-8");
                    Intrinsics.checkExpressionValueIsNotNull(list, "FileUtils.readLines(eulaFile, \"utf-8\")");
                    lines = list;
                } else {
                    lines = new ArrayList();
                    Collections.addAll((Collection)lines, "#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).", "#" + ZonedDateTime.now().format(DateTimeFormatter.ofPattern("E MMM d HH:mm:ss O y", Locale.ENGLISH)), "eula=false");
                }
                if (lines.size() <= 2 || StringsKt.contains$default((CharSequence)lines.get(2), "true", false, 2, null)) break block11;
                Closeable closeable = new Scanner(System.in, "utf-8");
                Throwable throwable = null;
                try {
                    String string;
                    String answer;
                    Scanner scanner = (Scanner)closeable;
                    PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), Ansi.ansi().fgCyan().a("You have not accepted the eula yet."), false, 2, null);
                    PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), Ansi.ansi().fgCyan().a("By typing TRUE you are indicating your agreement to the EULA of Mojang."), false, 2, null);
                    PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), Ansi.ansi().fgCyan().a("Read it at https://account.mojang.com/documents/minecraft_eula before accepting it."), false, 2, null);
                    String string2 = answer = scanner.nextLine();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "answer");
                    String string3 = string = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (StringsKt.equals(((Object)StringsKt.trim((CharSequence)string3)).toString(), "true", true)) {
                        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "You have accepted the EULA.", false, 2, null);
                        lines.set(2, "eula=true\n");
                        FileUtils.writeLines(eulaFile, (Collection)lines);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                ServerStarter.Companion.getLOGGER().error("Error while checking EULA", e);
            }
        }
    }

    public final void installForge(@NotNull String basePath, @NotNull String forgeVersion, @NotNull String mcVersion) {
        Intrinsics.checkParameterIsNotNull(basePath, "basePath");
        Intrinsics.checkParameterIsNotNull(forgeVersion, "forgeVersion");
        Intrinsics.checkParameterIsNotNull(mcVersion, "mcVersion");
        String versionString = mcVersion + '-' + forgeVersion;
        String url = "http://files.minecraftforge.net/maven/net/minecraftforge/forge/" + versionString + "/forge-" + versionString + "-installer.jar";
        File installerPath = new File(basePath + "forge-" + versionString + "-installer.jar");
        try {
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Attempting to download forge installer from " + url, false, 2, null);
            InternetManager.INSTANCE.downloadToFile(url, installerPath);
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Starting installation of Forge, installer output incoming", false, 2, null);
            ServerStarter.Companion.getLOGGER().info("Check log for installer for more information", true);
            Process installer = new ProcessBuilder("java", "-jar", installerPath.getAbsolutePath(), "--installServer").inheritIO().directory(new File(basePath + '.')).start();
            installer.waitFor();
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Done installing forge, deleting installer!", false, 2, null);
            ServerStarter.Companion.getLockFile().setForgeInstalled(true);
            ServerStarter.Companion.getLockFile().setForgeVersion(forgeVersion);
            ServerStarter.Companion.getLockFile().setMcVersion(mcVersion);
            ServerStarter.Companion.saveLockFile(ServerStarter.Companion.getLockFile());
            installerPath.delete();
            this.checkEULA(basePath);
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Problem while installing Forge", e);
        }
        catch (InterruptedException e) {
            ServerStarter.Companion.getLOGGER().error("Problem while installing Forge", e);
        }
    }

    @NotNull
    public final String installSpongeBootstrapper(@NotNull String basePath) {
        Intrinsics.checkParameterIsNotNull(basePath, "basePath");
        String filename = FilenameUtils.getName(this.configFile.getInstall().getSpongeBootstrapper());
        File downloadFile = new File(basePath + filename);
        try {
            InternetManager.INSTANCE.downloadToFile(this.configFile.getInstall().getSpongeBootstrapper(), downloadFile);
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Error while downloading bootstrapper", e);
        }
        String string = filename;
        Intrinsics.checkExpressionValueIsNotNull(string, "filename");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startServer() {
        try {
            ProcessBuilder processBuilder;
            Process $receiver;
            Process process;
            String it22;
            boolean bl;
            List ramPostArguments;
            List ramPreArguments;
            List arguments;
            File launchJar;
            Object levelName;
            block34: {
                Iterable $receiver$iv;
                Object object;
                Object props;
                try {
                    props = new Properties();
                    Object object2 = new File("server.properties");
                    object2 = new FileInputStream((File)object2);
                    Throwable throwable = null;
                    try {
                        Object it = (FileInputStream)object2;
                        ((Properties)props).load((InputStream)it);
                        it = Unit.INSTANCE;
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, throwable);
                    }
                    Object object3 = ((Properties)props).get("level-name");
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    props = (String)object3;
                }
                catch (FileNotFoundException e) {
                    props = "world";
                }
                levelName = props;
                String filename = this.configFile.getLaunch().getSpongefix() ? ServerStarter.Companion.getLockFile().getSpongeBootstrapper() : "forge-" + ServerStarter.Companion.getLockFile().getMcVersion() + '-' + ServerStarter.Companion.getLockFile().getForgeVersion() + ".jar";
                launchJar = new File(this.configFile.getInstall().getBaseInstallPath() + filename);
                arguments = new ArrayList();
                ramPreArguments = new ArrayList();
                ramPostArguments = new ArrayList();
                if (this.configFile.getLaunch().getRamDisk()) {
                    if (OSUtil.INSTANCE.isLinux()) {
                        CollectionsKt.addAll((Collection)ramPreArguments, new String[]{"rsync", "-aAXv", (String)levelName + "_backup/", levelName});
                    } else {
                        ServerStarter.Companion.getLOGGER().warn("Windows does not support RAMDisk yet!");
                    }
                }
                if (!((object = (CharSequence)this.configFile.getLaunch().getPreJavaArgs()).length() == 0)) {
                    object = this.configFile.getLaunch().getPreJavaArgs();
                    List list = arguments;
                    CharSequence charSequence = object;
                    if (charSequence == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    Object object4 = ((Object)StringsKt.trim(charSequence)).toString();
                    object = StringsKt.split$default((CharSequence)object4, new char[]{' '}, false, 0, 6, null);
                    boolean yielding$iv = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $receiver$iv) {
                        if (yielding$iv) {
                            list$iv.add(item$iv);
                            continue;
                        }
                        String it = (String)item$iv;
                        CharSequence charSequence2 = it;
                        if (charSequence2.length() == 0) continue;
                        list$iv.add(item$iv);
                        yielding$iv = true;
                    }
                    object4 = list$iv;
                    list.addAll((Collection)object4);
                }
                arguments.add("java");
                arguments.addAll((Collection)this.configFile.getLaunch().getJavaArgs());
                arguments.add("-Xmx" + this.configFile.getLaunch().getMaxRam());
                $receiver$iv = this.configFile.getLaunch().getJavaArgs();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Object item$iv;
                        it22 = (String)element$iv;
                        Object object5 = item$iv = it22;
                        if (object5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        if (!StringsKt.startsWith$default(((Object)StringsKt.trim((CharSequence)object5)).toString(), "-Xms", false, 2, null)) continue;
                        bl = false;
                        break block34;
                    }
                    bl = true;
                }
            }
            if (bl) {
                try {
                    String yielding$iv = this.configFile.getLaunch().getMaxRam();
                    int element$iv = 0;
                    int it22 = this.configFile.getLaunch().getMaxRam().length() - 1;
                    String string = yielding$iv;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(element$iv, it22);
                    Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int xmx = Integer.parseInt(string2);
                    int xms = Math.max(1, xmx / 2);
                    it22 = this.configFile.getLaunch().getMaxRam();
                    int item$iv = this.configFile.getLaunch().getMaxRam().length() - 1;
                    String string3 = it22;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(item$iv);
                    Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
                    String ending = string4;
                    arguments.add("-Xms" + xms + ending);
                }
                catch (NumberFormatException e) {
                    ServerStarter.Companion.getLOGGER().error("Problem while calculating XMS", e);
                }
            }
            CollectionsKt.addAll((Collection)arguments, new String[]{"-jar", launchJar.getAbsolutePath(), "nogui"});
            if (this.configFile.getLaunch().getRamDisk()) {
                boolean bl2 = OSUtil.INSTANCE.isLinux();
                if (bl2) {
                    CollectionsKt.addAll((Collection)ramPostArguments, new String[]{"rsync", "-aAXv", (String)levelName + '/', (String)levelName + "_backup"});
                } else if (!bl2) {
                    ServerStarter.Companion.getLOGGER().warn("Windows does not support RAMDisk yet!");
                }
            }
            ServerStarter.Companion.getLOGGER().info("Using arguments: " + arguments, true);
            PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Starting Forge, output incoming", false, 2, null);
            ServerStarter.Companion.getLOGGER().info("For output of this check the server log", true);
            if (this.configFile.getLaunch().getRamDisk()) {
                ProcessBuilder processBuilder2;
                ProcessBuilder $receiver2 = processBuilder2 = new ProcessBuilder(ramPreArguments);
                $receiver2.inheritIO();
                $receiver2.directory(new File(this.configFile.getInstall().getBaseInstallPath() + "."));
                $receiver = process = $receiver2.start();
                $receiver.waitFor();
                $receiver.getOutputStream().close();
                $receiver.getErrorStream().close();
                $receiver.getInputStream().close();
            }
            ProcessBuilder $receiver3 = processBuilder = new ProcessBuilder(arguments);
            $receiver3.inheritIO();
            $receiver3.directory(new File(this.configFile.getInstall().getBaseInstallPath() + "."));
            $receiver = process = $receiver3.start();
            $receiver.waitFor();
            $receiver.getOutputStream().close();
            $receiver.getErrorStream().close();
            $receiver.getInputStream().close();
            if (this.configFile.getLaunch().getRamDisk()) {
                $receiver3 = processBuilder = new ProcessBuilder(ramPostArguments);
                $receiver3.inheritIO();
                $receiver3.directory(new File(this.configFile.getInstall().getBaseInstallPath() + "."));
                $receiver = process = $receiver3.start();
                $receiver.waitFor();
                $receiver.getOutputStream().close();
                $receiver.getErrorStream().close();
                $receiver.getInputStream().close();
            }
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Error while starting the server", e);
        }
        catch (InterruptedException e) {
            ServerStarter.Companion.getLOGGER().error("Error while starting the server", e);
        }
    }

    public ForgeManager(@NotNull ConfigFile configFile) {
        Intrinsics.checkParameterIsNotNull(configFile, "configFile");
        this.configFile = configFile;
    }
}

