/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.world;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.building.view.SimpleBuildContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
public class FakeDelegationWorld
implements IWorld {
    private final IWorld world;
    private Map<BlockPos, BlockState> posToState;
    private Map<BlockPos, TileEntity> posToTile;

    public FakeDelegationWorld(IWorld world) {
        this.world = Objects.requireNonNull(world);
        this.posToState = new HashMap<BlockPos, BlockState>();
        this.posToTile = new HashMap<BlockPos, TileEntity>();
    }

    public void addBlock(@Nonnull BlockPos pos, BlockData data) {
        this.addBlock(null, pos, data);
    }

    public void addBlock(@Nullable IBuildContext context, @Nonnull BlockPos pos, BlockData data) {
        if (data != null) {
            data.placeIn(SimpleBuildContext.builderOf(context).build(this), pos);
        }
    }

    public IWorld getDelegate() {
        return this.world;
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public List<Entity> func_175674_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        return null;
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> aClass, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        return null;
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return null;
    }

    @Nullable
    public IChunk func_217353_a(int p_217353_1_, int p_217353_2_, ChunkStatus p_217353_3_, boolean p_217353_4_) {
        return null;
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return null;
    }

    public boolean func_217377_a(BlockPos blockPos, boolean b) {
        return false;
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return false;
    }

    @Nullable
    private BlockState getOverriddenState(BlockPos pos) {
        return this.posToState.get(pos);
    }

    @Nullable
    private TileEntity getOverriddenTile(BlockPos pos) {
        return this.posToTile.get(pos);
    }

    public long func_72905_C() {
        return this.world.func_72905_C();
    }

    public float func_130001_d() {
        return this.world.func_130001_d();
    }

    public float func_72826_c(float partialTicks) {
        return this.world.func_72826_c(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_72853_d() {
        return this.world.func_72853_d();
    }

    public ITickList<Block> func_205220_G_() {
        return this.world.func_205220_G_();
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.world.func_205219_F_();
    }

    public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.world.func_212866_a_(chunkX, chunkZ);
    }

    public World func_201672_e() {
        return this.world.func_201672_e();
    }

    public WorldInfo func_72912_H() {
        return this.world.func_72912_H();
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.world.func_175649_E(pos);
    }

    public Difficulty func_175659_aa() {
        return this.world.func_175659_aa();
    }

    public AbstractChunkProvider func_72863_F() {
        return this.world.func_72863_F();
    }

    public Random func_201674_k() {
        return this.world.func_201674_k();
    }

    public void func_195592_c(BlockPos pos, Block blockIn) {
    }

    public BlockPos func_175694_M() {
        return this.world.func_175694_M();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public int func_175642_b(LightType type, BlockPos pos) {
        return this.world.func_175642_b(type, pos);
    }

    public int func_201669_a(BlockPos pos, int amount) {
        return this.world.func_201669_a(pos, amount);
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.world.func_201676_a(heightmapType, x, z);
    }

    public int func_175657_ab() {
        return this.world.func_175657_ab();
    }

    public WorldBorder func_175723_af() {
        return this.world.func_175723_af();
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return this.world.func_195585_a(entityIn, shape);
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public boolean func_201670_d() {
        return this.world.func_201670_d();
    }

    public int func_181545_F() {
        return this.world.func_181545_F();
    }

    public Dimension func_201675_m() {
        return this.world.func_201675_m();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        TileEntity tile = this.getOverriddenTile(pos);
        if (tile != null) {
            return tile;
        }
        BlockState state = this.getOverriddenState(pos);
        if (state != null) {
            if (!state.hasTileEntity()) {
                return null;
            }
            tile = state.createTileEntity((IBlockReader)this);
            if (tile != null) {
                tile.func_174878_a(pos);
                this.posToTile.put(pos, tile);
                return tile;
            }
        }
        return this.world.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        BlockState state = this.getOverriddenState(pos);
        return state != null ? state : this.world.func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public int func_201572_C() {
        return this.world.func_201572_C();
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        this.posToState.put(pos, newState);
        return true;
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return !this.func_180495_p(pos).isAir((IBlockReader)this, pos) && this.func_217377_a(pos, true);
    }
}

