/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools.modes;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.modes.IBuildingMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingGridMode;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingHorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingSurfaceMode;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingVerticalColumnMode;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public enum ExchangingMode {
    SURFACE("surface.png", new ExchangingSurfaceMode(ExchangingMode::combineTester)),
    VERTICAL_COLUMN("vertical_column.png", new ExchangingVerticalColumnMode(ExchangingMode::combineTester)),
    HORIZONTAL_COLUMN("horizontal_column.png", new ExchangingHorizontalColumnMode(ExchangingMode::combineTester)),
    GRID("grid.png", new ExchangingGridMode(ExchangingMode::combineTester));

    private static final ExchangingMode[] VALUES;
    private final ResourceLocation icon;
    private final IBuildingMode modeImpl;
    private static final ImmutableList<ResourceLocation> ICONS;

    private ExchangingMode(String iconFile, IBuildingMode modeImpl) {
        this.icon = new ResourceLocation("buildinggadgets", "textures/gui/mode/" + iconFile);
        this.modeImpl = modeImpl;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public IBuildingMode getModeImplementation() {
        return this.modeImpl;
    }

    public String getRegistryName() {
        return this.getModeImplementation().getRegistryName().toString() + "/ExchangingGadget";
    }

    public String toString() {
        return this.getModeImplementation().getLocalizedName();
    }

    public ExchangingMode next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static ExchangingMode byName(String name) {
        return Arrays.stream(VALUES).filter(mode -> mode.getRegistryName().equals(name)).findFirst().orElse(SURFACE);
    }

    public static ImmutableList<ResourceLocation> getIcons() {
        return ICONS;
    }

    public static List<BlockPos> collectPlacementPos(IWorld world, PlayerEntity player, BlockPos hit, Direction sideHit, ItemStack tool, BlockPos initial) {
        IBuildingMode mode = ExchangingMode.byName(NBTHelper.getOrNewTag(tool).func_74779_i("mode")).getModeImplementation();
        return mode.createExecutionContext(player, hit, sideHit, tool, initial).collectFilteredSequence();
    }

    public static BiPredicate<BlockPos, BlockData> combineTester(IWorld world, ItemStack tool, PlayerEntity player, BlockPos initial) {
        BlockState initialBlockState = world.func_180495_p(initial);
        BlockData target = GadgetUtils.getToolBlock(tool);
        return (pos, data) -> {
            BlockState worldBlockState = world.func_180495_p(pos);
            if (worldBlockState == target.getState()) {
                return false;
            }
            if (!AbstractGadget.getFuzzy(tool) && worldBlockState != initialBlockState) {
                return false;
            }
            if (worldBlockState == BGBlocks.effectBlock.func_176223_P()) {
                return false;
            }
            if (worldBlockState.func_177230_c().isAir(worldBlockState, (IBlockReader)world, pos)) {
                return false;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)tile).getConstructionBlockData().equals(data) : tile != null) {
                return false;
            }
            if (worldBlockState.func_185887_b((IBlockReader)world, pos) < 0.0f) {
                return false;
            }
            return !worldBlockState.func_185904_a().func_76224_d();
        };
    }

    static {
        VALUES = ExchangingMode.values();
        ICONS = (ImmutableList)Arrays.stream(VALUES).map(ExchangingMode::getIcon).collect(ImmutableList.toImmutableList());
    }
}

