/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.container;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.IContainerFactory;

public final class ScreenContainerBuilder<T extends Container, U extends Screen> {
    private final IContainerFactory<T> containerFactory;
    private final Supplier<Supplier<ScreenManager.IScreenFactory<T, U>>> screenFactory;
    private ContainerType<T> type;

    public ScreenContainerBuilder(IContainerFactory<T> containerFactory, Supplier<Supplier<ScreenManager.IScreenFactory<T, U>>> screenFactory) {
        this.containerFactory = Objects.requireNonNull(containerFactory);
        this.screenFactory = Objects.requireNonNull(screenFactory);
        this.type = null;
    }

    ContainerType<T> getOrCreate() {
        if (this.type != null) {
            return this.type;
        }
        this.type = IForgeContainerType.create(this.containerFactory);
        return this.type;
    }

    void registerScreen() {
        Preconditions.checkArgument((this.type != null && this.screenFactory.get() != null && this.screenFactory.get().get() != null ? 1 : 0) != 0);
        ScreenManager.func_216911_a(this.type, this.screenFactory.get().get());
    }
}

