/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.util.CapabilityUtil;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.modes.BuildingMode;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public class BuildingRender
extends BaseRenderer {
    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        Vec3d playerPos = BaseRenderer.getPlayerPos();
        BlockState state = BaseRenderer.AIR;
        List<BlockPos> coordinates = GadgetUtils.getAnchor(heldItem);
        if (lookingAt != null && player.field_70170_p.func_180495_p(VectorHelper.getLookingAt(player, heldItem).func_216350_a()) != BaseRenderer.AIR || coordinates.size() > 0) {
            World world = player.field_70170_p;
            BlockState startBlock = BaseRenderer.AIR;
            if (lookingAt != null) {
                startBlock = world.func_180495_p(lookingAt.func_216350_a());
            }
            if (startBlock != BGBlocks.effectBlock.func_176223_P()) {
                BlockState renderBlockState = GadgetUtils.getToolBlock(heldItem).getState();
                if (renderBlockState == BaseRenderer.AIR) {
                    return;
                }
                if (coordinates.size() == 0 && lookingAt != null) {
                    coordinates = BuildingMode.collectPlacementPos((IWorld)world, player, lookingAt.func_216350_a(), lookingAt.func_216354_b(), heldItem, lookingAt.func_216350_a());
                }
                ItemStack itemStack = this.getItemStackForRender(renderBlockState, player, (IWorld)world);
                long hasBlocks = this.playerHasBlocks(itemStack, player, renderBlockState);
                int hasEnergy = this.getEnergy(player, heldItem);
                LazyOptional<IEnergyStorage> energyCap = CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)heldItem);
                BuildingRender.getBuilderWorld().setWorldAndState(player.field_70170_p, renderBlockState, coordinates);
                GlStateManager.pushMatrix();
                GlStateManager.pushTextureAttributes();
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((int)32771, (int)32772);
                List<BlockPos> sortedCoordinates = SortingHelper.Blocks.byDistance(coordinates, player);
                for (BlockPos coordinate : sortedCoordinates) {
                    GlStateManager.pushMatrix();
                    GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                    GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    if (BuildingRender.getBuilderWorld().getWorldType() != WorldType.field_180272_g) {
                        try {
                            state = renderBlockState;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        BuildingRender.getMc().func_175602_ab().func_175016_a(state, 1.0f);
                    }
                    catch (Throwable t) {
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder bufferBuilder = tessellator.func_178180_c();
                        bufferBuilder.func_178977_d();
                    }
                    GlStateManager.popMatrix();
                }
                for (BlockPos coordinate : coordinates) {
                    GlStateManager.pushMatrix();
                    GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                    GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)-0.005f, (float)-0.005f, (float)0.005f);
                    GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
                    --hasBlocks;
                    if (energyCap.isPresent()) {
                        hasEnergy -= ((AbstractGadget)heldItem.func_77973_b()).getEnergyCost(heldItem);
                    }
                    if (hasBlocks < 0L || hasEnergy < 0) {
                        BuildingRender.getMc().func_175602_ab().func_175016_a(Blocks.field_196823_gx.func_176223_P(), 1.0f);
                    }
                    GlStateManager.popMatrix();
                }
                if (state.hasTileEntity()) {
                    TileEntity te = BuildingRender.getTileEntityWorld().getTE(state, world);
                    TileEntityRenderer<TileEntity> teRender = BuildingRender.getTileEntityWorld().getTER(state, world);
                    if (teRender != null && !BuildingRender.getInvalidTileEntities().contains(te)) {
                        for (BlockPos coordinate : coordinates) {
                            te.func_174878_a(coordinate);
                            GlStateManager.pushMatrix();
                            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                            GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.enableBlend();
                            GlStateManager.blendFunc((int)32771, (int)32772);
                            try {
                                TileEntityRendererDispatcher.field_147556_a.func_203602_a(te, 0.0, 0.0, 0.0, evt.getPartialTicks(), -1, true);
                            }
                            catch (Exception e) {
                                System.out.println("TER Exception with block type: " + state);
                                BuildingRender.getInvalidTileEntities().add(te);
                                GlStateManager.disableFog();
                                GlStateManager.popMatrix();
                                break;
                            }
                            GlStateManager.disableFog();
                            GlStateManager.popMatrix();
                        }
                    }
                }
                GlStateManager.blendFunc((int)770, (int)771);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
                GlStateManager.disableBlend();
                GlStateManager.popAttributes();
                GlStateManager.popMatrix();
            }
        }
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

