/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.util;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.materials.UniqueItem;
import com.direwolf20.buildinggadgets.api.util.DelegatingPlacementSequence;
import com.direwolf20.buildinggadgets.api.util.FilterSpliterator;
import com.direwolf20.buildinggadgets.api.util.PositionValidatingSpliterator;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class CommonUtils {
    public static final Comparator<Vec3i> POSITION_COMPARATOR = Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177956_o).thenComparingInt(Vec3i::func_177952_p);

    private CommonUtils() {
    }

    public static <T> IPlacementSequence<T> filterSequence(IPlacementSequence<T> sequence, Predicate<T> filter) {
        return CommonUtils.filterSequence(sequence, Function.identity(), filter);
    }

    public static <T, U> IPlacementSequence<T> filterSequence(IPlacementSequence<U> sequence, Function<U, T> mapper, final Predicate<T> filter) {
        return new DelegatingPlacementSequence<T, U>(sequence, mapper){

            @Override
            public Spliterator<T> spliterator() {
                return new FilterSpliterator(super.spliterator(), filter);
            }
        };
    }

    public static <T> IPlacementSequence<T> emptySequence() {
        return new IPlacementSequence<T>(){

            @Override
            public Region getBoundingBox() {
                return new Region((Vec3i)new BlockPos(0, 0, 0));
            }

            @Override
            public boolean mayContain(int x, int y, int z) {
                return false;
            }

            @Override
            public IPlacementSequence<T> copy() {
                return CommonUtils.emptySequence();
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    public static IPositionPlacementSequence emptyPositionSequence() {
        return CommonUtils.mapToPositionPlacementSequence(CommonUtils.emptySequence(), Function.identity());
    }

    public static <T, U> IPlacementSequence<U> map(IPlacementSequence<T> sequence, Function<T, U> mapper) {
        return new DelegatingPlacementSequence<U, T>(sequence, mapper);
    }

    public static IPositionPlacementSequence mapToPositionPlacementSequence(IPlacementSequence<BlockPos> sequence) {
        return CommonUtils.mapToPositionPlacementSequence(sequence, Function.identity());
    }

    public static <T> IPositionPlacementSequence mapToPositionPlacementSequence(final IPlacementSequence<T> sequence, final Function<T, BlockPos> positionGenerator) {
        final IPlacementSequence<BlockPos> mapped = CommonUtils.map(sequence, positionGenerator);
        return new IPositionPlacementSequence(){

            @Override
            public Spliterator<BlockPos> spliterator() {
                return mapped.spliterator();
            }

            @Override
            public Iterator<BlockPos> iterator() {
                return Spliterators.iterator(this.spliterator());
            }

            @Override
            public IPositionPlacementSequence copy() {
                return CommonUtils.mapToPositionPlacementSequence(sequence, positionGenerator);
            }

            @Override
            public Region getBoundingBox() {
                return sequence.getBoundingBox();
            }

            @Override
            public boolean mayContain(int x, int y, int z) {
                return sequence.mayContain(x, y, z);
            }
        };
    }

    public static IPositionPlacementSequence validatePositionData(final IPositionPlacementSequence sequence, final BiPredicate<BlockPos, BlockData> predicate, final Function<BlockPos, BlockData> dataExtractor) {
        return new IPositionPlacementSequence(){

            @Override
            public Spliterator<BlockPos> spliterator() {
                return new PositionValidatingSpliterator(sequence.spliterator(), predicate, dataExtractor);
            }

            @Override
            public Iterator<BlockPos> iterator() {
                return Spliterators.iterator(this.spliterator());
            }

            @Override
            public IPositionPlacementSequence copy() {
                return CommonUtils.validatePositionData(sequence, predicate, dataExtractor);
            }

            @Override
            public Region getBoundingBox() {
                return sequence.getBoundingBox();
            }

            @Override
            public boolean mayContain(int x, int y, int z) {
                return sequence.mayContain(x, y, z);
            }
        };
    }

    public static BlockRayTraceResult fakeRayTrace(Vec3d simulatePos, BlockPos pos) {
        return CommonUtils.fakeRayTrace(simulatePos.func_82615_a(), simulatePos.func_82617_b(), simulatePos.func_82616_c(), pos);
    }

    public static BlockRayTraceResult fakeRayTrace(double simX, double simY, double simZ, BlockPos pos) {
        Vec3d simVec = new Vec3d((Vec3i)pos).func_178786_a(simX, simY, simZ);
        Direction dir = Direction.func_210769_a((double)simVec.func_82615_a(), (double)simVec.func_82617_b(), (double)simVec.func_82616_c());
        return new BlockRayTraceResult(simVec, dir, pos, false);
    }

    public static MaterialList estimateRequiredItems(Iterable<PlacementTarget> buildView, IBuildContext context) {
        PlayerEntity player = context.getBuildingPlayer();
        return CommonUtils.estimateRequiredItems(buildView, context, player != null ? new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v) : null);
    }

    public static MaterialList estimateRequiredItems(Iterable<PlacementTarget> buildView, IBuildContext context, @Nullable Vec3d simulatePos) {
        MaterialList.Builder builder = MaterialList.builder();
        for (PlacementTarget placementTarget : buildView) {
            BlockRayTraceResult target = simulatePos != null ? CommonUtils.fakeRayTrace(simulatePos, placementTarget.getPos()) : null;
            builder.addAll((Collection<UniqueItem>)placementTarget.getRequiredItems(context, (RayTraceResult)target).getRequiredItems().asList());
        }
        return builder.build();
    }

    public static ImmutableMap<BlockPos, BlockData> targetsToMap(Iterable<PlacementTarget> iterable) {
        return (ImmutableMap)StreamSupport.stream(iterable.spliterator(), false).collect(ImmutableMap.toImmutableMap(PlacementTarget::getPos, PlacementTarget::getData));
    }

    public static <T> Function<T, T> inputIfNonNullFunction(@Nullable T otherRes) {
        return t -> otherRes != null ? otherRes : t;
    }
}

