/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template.transaction;

import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.template.transaction.AbsSingleRunTransactionOperator;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionOperator;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

final class RotateOperator
extends AbsSingleRunTransactionOperator {
    private final int[][] matrix;
    private final Rotation rot;

    private static int sineForRotation(Rotation rot) {
        switch (rot) {
            case NONE: 
            case CLOCKWISE_180: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return -1;
            }
        }
        throw new AssertionError();
    }

    private static int cosineForRotation(Rotation rot) {
        return RotateOperator.sineForRotation(rot.func_185830_a(Rotation.CLOCKWISE_90));
    }

    private static int[][] rotationMatrixFor(Direction.Axis axis, Rotation rotation) {
        int[][] matrix = new int[3][3];
        switch (axis) {
            case X: {
                matrix[0][0] = 1;
                matrix[1][1] = RotateOperator.cosineForRotation(rotation);
                matrix[1][2] = -RotateOperator.sineForRotation(rotation);
                matrix[2][1] = RotateOperator.sineForRotation(rotation);
                matrix[2][2] = RotateOperator.cosineForRotation(rotation);
            }
            case Y: {
                matrix[1][1] = 1;
                matrix[0][0] = RotateOperator.cosineForRotation(rotation);
                matrix[2][0] = -RotateOperator.sineForRotation(rotation);
                matrix[0][2] = RotateOperator.sineForRotation(rotation);
                matrix[2][2] = RotateOperator.cosineForRotation(rotation);
            }
            case Z: {
                matrix[2][2] = 1;
                matrix[0][0] = RotateOperator.cosineForRotation(rotation);
                matrix[0][1] = -RotateOperator.sineForRotation(rotation);
                matrix[1][0] = RotateOperator.sineForRotation(rotation);
                matrix[1][1] = RotateOperator.cosineForRotation(rotation);
            }
        }
        return matrix;
    }

    RotateOperator(Rotation rotation) {
        this(Direction.Axis.Y, rotation);
    }

    RotateOperator(Direction.Axis axis, Rotation rotation) {
        super(EnumSet.of(ITransactionOperator.TransactionOperation.TRANSFORM_TARGET));
        this.matrix = RotateOperator.rotationMatrixFor(axis, rotation);
        this.rot = axis == Direction.Axis.Y ? rotation : Rotation.NONE;
    }

    @Override
    @Nullable
    public PlacementTarget transformTarget(ITransactionExecutionContext context, PlacementTarget target) {
        return super.transformTarget(context, new PlacementTarget(this.matrixMul(target.getPos()), target.getData().rotate(this.rot)));
    }

    private BlockPos matrixMul(BlockPos pos) {
        int x = pos.func_177958_n() * this.matrix[0][0] + pos.func_177956_o() * this.matrix[0][1] + pos.func_177952_p() * this.matrix[0][2];
        int y = pos.func_177958_n() * this.matrix[1][0] + pos.func_177956_o() * this.matrix[1][1] + pos.func_177952_p() * this.matrix[1][2];
        int z = pos.func_177958_n() * this.matrix[2][0] + pos.func_177956_o() * this.matrix[2][1] + pos.func_177952_p() * this.matrix[2][2];
        return new BlockPos(x, y, z);
    }
}

