/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.view;

import com.direwolf20.buildinggadgets.api.BuildingGadgetsAPI;
import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.IBlockProvider;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.building.view.IBuildView;
import com.direwolf20.buildinggadgets.api.building.view.IValidatorFactory;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.util.CommonUtils;
import com.direwolf20.buildinggadgets.api.util.MappingSpliterator;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class SimpleBuildView
implements IBuildView {
    private final IPositionPlacementSequence positions;
    private IBlockProvider<?> blocks;
    private final IValidatorFactory validatorFactory;
    private IBuildContext context;
    private BlockPos start;
    @Nullable
    private MaterialList materials;

    public SimpleBuildView(IPositionPlacementSequence positions, IBlockProvider<?> blocks, IBuildContext context) {
        this(positions, blocks, (world, stack, player, initial) -> (pos, state) -> true, context, null);
    }

    public SimpleBuildView(IPositionPlacementSequence positions, IBlockProvider<?> blocks, IValidatorFactory validatorFactory, IBuildContext buildContext, @Nullable BlockPos start) {
        this.positions = positions;
        this.blocks = Objects.requireNonNull(blocks, "Cannot have a SimpleBuildView without IBlockProvider!");
        this.validatorFactory = validatorFactory;
        if (buildContext.getBuildingPlayer() == null) {
            BuildingGadgetsAPI.LOG.warn("Constructing SimpleBuildView without a player. This may lead to errors down the line, if the used IValidatorFactory doesn't handle null Players!");
        }
        this.context = buildContext;
        this.start = start;
        this.materials = null;
    }

    @Override
    public Spliterator<PlacementTarget> spliterator() {
        return new MappingSpliterator<BlockPos, PlacementTarget>(this.getFilteredSequence().spliterator(), pos -> new PlacementTarget((BlockPos)pos, this.getBlockProvider().at((BlockPos)pos)));
    }

    @Override
    public IBuildView translateTo(BlockPos pos) {
        this.blocks = this.blocks.translate(pos);
        this.materials = null;
        return this;
    }

    @Override
    @Nullable
    public MaterialList estimateRequiredItems(@Nullable Vec3d simulatePos) {
        if (this.materials == null) {
            this.materials = IBuildView.super.estimateRequiredItems(simulatePos);
        }
        return this.materials;
    }

    @Override
    public int estimateSize() {
        return this.getBoundingBox().size();
    }

    @Override
    public void close() {
    }

    @Override
    public IBuildView copy() {
        return new SimpleBuildView(this.getPositionSequence(), this.getBlockProvider(), this.getValidatorFactory(), this.context, this.start);
    }

    @Override
    public Region getBoundingBox() {
        return this.getPositionSequence().getBoundingBox();
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.getPositionSequence().mayContain(x, y, z);
    }

    private IPositionPlacementSequence getFilteredSequence() {
        BiPredicate<BlockPos, BlockData> validator = this.validatorFactory.createValidatorFor(this.context.getWorld(), this.context.getUsedStack(), this.context.getBuildingPlayer(), this.start);
        return CommonUtils.validatePositionData(this.getPositionSequence(), validator, this.getBlockProvider()::at);
    }

    public ImmutableList<BlockPos> collectFilteredSequence() {
        return ImmutableList.copyOf((Iterable)this.getFilteredSequence());
    }

    public IPositionPlacementSequence getPositionSequence() {
        return this.positions;
    }

    public IBlockProvider getBlockProvider() {
        return this.blocks;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    @Override
    public IBuildContext getContext() {
        return this.context;
    }
}

