/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.event.EventHandler;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.setup.ClientProxy;
import com.lothrazar.cyclic.setup.ConfigHandler;
import com.lothrazar.cyclic.setup.IProxy;
import com.lothrazar.cyclic.setup.ServerProxy;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cyclic")
public class ModCyclic {
    public static final String certificateFingerprint = "@FINGERPRINT@";
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final String MODID = "cyclic";
    public static final Logger LOGGER = LogManager.getLogger();

    public ModCyclic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        ConfigHandler.loadConfig(ConfigHandler.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("cyclic.toml"));
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketRegistry.init();
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.soundproofing);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.excavate);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.experience_boost);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.life_leech);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.magnet);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.multishot);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.venom);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "cyclicInvalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        System.out.println(msg);
    }
}

