/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.compat.silentsmechanisms;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.mechanisms.crafting.recipe.CrushingRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.JAOPCAApi;

public class CrushingRecipeSupplier
implements Supplier<CrushingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int time;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.time = time;
    }

    @Override
    public CrushingRecipe get() {
        Ingredient ing = JAOPCAApi.instance().miscHelper().getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        LinkedHashMap<ItemStack, Float> results = new LinkedHashMap<ItemStack, Float>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = JAOPCAApi.instance().miscHelper().getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            results.put(stack, chance);
        }
        try {
            CrushingRecipe ret = new CrushingRecipe(this.key);
            Field processTimeField = CrushingRecipe.class.getDeclaredField("processTime");
            Field ingredientField = CrushingRecipe.class.getDeclaredField("ingredient");
            Field resultsField = CrushingRecipe.class.getDeclaredField("results");
            processTimeField.setAccessible(true);
            ingredientField.setAccessible(true);
            resultsField.setAccessible(true);
            processTimeField.setInt(ret, this.time);
            ingredientField.set(ret, ing);
            resultsField.set(ret, results);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

