/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.active;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.blocks.IBlockInfo;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;

@JAOPCAModule
public class StorageBlocksModule
implements IModule {
    private final IForm storageBlockForm = JAOPCAApi.instance().newForm(this, "storage_blocks", JAOPCAApi.instance().blockFormType());

    @Override
    public String getName() {
        return "storage_blocks";
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.storageBlockForm.toRequest());
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        JAOPCAApi api = JAOPCAApi.instance();
        for (IMaterial material : this.storageBlockForm.getMaterials()) {
            if (material.getType().isDummy()) continue;
            ResourceLocation materialLocation = api.miscHelper().getTagLocation(material.getType().getFormName(), material.getName());
            IBlockInfo storageBlockInfo = api.blockFormType().getMaterialFormInfo(this.storageBlockForm, material);
            api.registerShapedRecipe(new ResourceLocation("jaopca", "storage_blocks.to_storage_block." + material.getName()), storageBlockInfo, 1, "MMM", "MMM", "MMM", Character.valueOf('M'), materialLocation);
            api.registerShapelessRecipe(new ResourceLocation("jaopca", "storage_blocks.to_material." + material.getName()), materialLocation, 9, storageBlockInfo);
        }
    }
}

