/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.materials;

import java.util.Locale;

public enum MaterialType {
    INGOT("ingots"),
    GEM("gems"),
    CRYSTAL("crystals"),
    DUST("dusts"),
    INGOT_PLAIN("ingots"),
    GEM_PLAIN("gems"),
    CRYSTAL_PLAIN("crystals"),
    DUST_PLAIN("dusts"),
    DUMMY("");

    public static final MaterialType[] INGOTS;
    public static final MaterialType[] GEMS;
    public static final MaterialType[] CRYSTALS;
    public static final MaterialType[] DUSTS;
    public static final MaterialType[] NON_DUSTS;
    public static final MaterialType[] ORE;
    private final String formName;

    private MaterialType(String formName) {
        this.formName = formName;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.US);
    }

    public String getFormName() {
        return this.formName;
    }

    public boolean isDummy() {
        return this == DUMMY;
    }

    static {
        INGOTS = new MaterialType[]{INGOT, INGOT_PLAIN};
        GEMS = new MaterialType[]{GEM, GEM_PLAIN};
        CRYSTALS = new MaterialType[]{CRYSTAL, CRYSTAL_PLAIN};
        DUSTS = new MaterialType[]{DUST, DUST_PLAIN};
        NON_DUSTS = new MaterialType[]{INGOT, GEM, CRYSTAL, INGOT_PLAIN, GEM_PLAIN, CRYSTAL_PLAIN};
        ORE = new MaterialType[]{INGOT, GEM, CRYSTAL, DUST};
    }
}

