/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class BlockStateProperty
implements ILootCondition {
    private final Block field_215990_a;
    private final Map<IProperty<?>, Object> field_215991_b;
    private final Predicate<BlockState> field_215992_c;

    private BlockStateProperty(Block block, Map<IProperty<?>, Object> map) {
        this.field_215990_a = block;
        this.field_215991_b = ImmutableMap.copyOf(map);
        this.field_215992_c = BlockStateProperty.func_215984_a(block, map);
    }

    private static Predicate<BlockState> func_215984_a(Block block, Map<IProperty<?>, Object> map) {
        int n = map.size();
        if (n == 0) {
            return blockState -> blockState.func_177230_c() == block;
        }
        if (n == 1) {
            Map.Entry<IProperty<?>, Object> entry = map.entrySet().iterator().next();
            IProperty<?> \u26032 = entry.getKey();
            Object \u26033 = entry.getValue();
            return blockState -> blockState.func_177230_c() == block && \u26033.equals(blockState.func_177229_b(\u26032));
        }
        Predicate<BlockState> \u26035 = blockState -> blockState.func_177230_c() == block;
        for (Map.Entry<IProperty<?>, Object> entry : map.entrySet()) {
            IProperty<?> iProperty = entry.getKey();
            Object \u26034 = entry.getValue();
            \u26035 = \u26035.and(blockState -> \u26034.equals(blockState.func_177229_b(iProperty)));
        }
        return \u26035;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216287_g);
    }

    @Override
    public boolean test(LootContext lootContext) {
        BlockState blockState = lootContext.func_216031_c(LootParameters.field_216287_g);
        return blockState != null && this.field_215992_c.test(blockState);
    }

    public static Builder func_215985_a(Block block) {
        return new Builder(block);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<BlockStateProperty> {
        private static <T extends Comparable<T>> String func_216294_a(IProperty<T> iProperty, Object object) {
            return iProperty.func_177702_a((Comparable)object);
        }

        protected Serializer() {
            super(new ResourceLocation("block_state_property"), BlockStateProperty.class);
        }

        @Override
        public void func_186605_a(JsonObject jsonObject, BlockStateProperty blockStateProperty, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(blockStateProperty.field_215990_a).toString());
            JsonObject jsonObject2 = new JsonObject();
            blockStateProperty.field_215991_b.forEach((iProperty, object) -> jsonObject2.addProperty(iProperty.func_177701_a(), Serializer.func_216294_a(iProperty, object)));
            jsonObject.add("properties", (JsonElement)jsonObject2);
        }

        @Override
        public BlockStateProperty func_186603_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "block"));
            Block \u26032 = (Block)Registry.field_212618_g.func_218349_b(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + resourceLocation));
            StateContainer<Block, BlockState> \u26033 = \u26032.func_176194_O();
            HashMap \u26034 = Maps.newHashMap();
            if (jsonObject.has("properties")) {
                JsonObject jsonObject2 = JSONUtils.func_152754_s(jsonObject, "properties");
                jsonObject2.entrySet().forEach(entry -> {
                    String string = (String)entry.getKey();
                    IProperty<?> \u26032 = \u26033.func_185920_a(string);
                    if (\u26032 == null) {
                        throw new IllegalArgumentException("Block " + Registry.field_212618_g.func_177774_c(\u26032) + " does not have property '" + string + "'");
                    }
                    \u2603 = JSONUtils.func_151206_a((JsonElement)entry.getValue(), "value");
                    Object \u26033 = \u26032.func_185929_b(\u2603).orElseThrow(() -> new IllegalArgumentException("Block " + Registry.field_212618_g.func_177774_c(\u26032) + " property '" + string + "' does not have value '" + \u2603 + "'"));
                    \u26034.put(\u26032, \u26033);
                });
            }
            return new BlockStateProperty(\u26032, \u26034);
        }

        @Override
        public /* synthetic */ ILootCondition func_186603_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.func_186603_b(jsonObject, jsonDeserializationContext);
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final Block field_216300_a;
        private final Set<IProperty<?>> field_216301_b;
        private final Map<IProperty<?>, Object> field_216302_c = Maps.newHashMap();

        public Builder(Block block) {
            this.field_216300_a = block;
            this.field_216301_b = Sets.newIdentityHashSet();
            this.field_216301_b.addAll(block.func_176194_O().func_177623_d());
        }

        public <T extends Comparable<T>> Builder func_216299_a(IProperty<T> iProperty, T t) {
            if (!this.field_216301_b.contains(iProperty)) {
                throw new IllegalArgumentException("Block " + Registry.field_212618_g.func_177774_c(this.field_216300_a) + " does not have property '" + iProperty + "'");
            }
            if (!iProperty.func_177700_c().contains(t)) {
                throw new IllegalArgumentException("Block " + Registry.field_212618_g.func_177774_c(this.field_216300_a) + " property '" + iProperty + "' does not have value '" + t + "'");
            }
            this.field_216302_c.put(iProperty, t);
            return this;
        }

        @Override
        public ILootCondition build() {
            return new BlockStateProperty(this.field_216300_a, this.field_216302_c);
        }
    }
}

