/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHangWatchdog
implements Runnable {
    private static final Logger field_180251_a = LogManager.getLogger();
    private final DedicatedServer field_180249_b;
    private final long field_180250_c;

    public ServerHangWatchdog(DedicatedServer dedicatedServer) {
        this.field_180249_b = dedicatedServer;
        this.field_180250_c = dedicatedServer.func_175593_aQ();
    }

    @Override
    public void run() {
        while (this.field_180249_b.func_71278_l()) {
            long l = this.field_180249_b.func_211150_az();
            \u2603 = Util.func_211177_b();
            \u2603 = \u2603 - l;
            if (\u2603 > this.field_180250_c) {
                field_180251_a.fatal("A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)\u2603 / 1000.0f)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(0.05f)));
                field_180251_a.fatal("Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
                StringBuilder \u26033 = new StringBuilder();
                Error \u26034 = new Error();
                for (ThreadInfo threadInfo : \u26032) {
                    if (threadInfo.getThreadId() == this.field_180249_b.func_213170_ax().getId()) {
                        \u26034.setStackTrace(threadInfo.getStackTrace());
                    }
                    \u26033.append(threadInfo);
                    \u26033.append("\n");
                }
                CrashReport crashReport = new CrashReport("Watching Server", \u26034);
                this.field_180249_b.func_71230_b(crashReport);
                CrashReportCategory \u26035 = crashReport.func_85058_a("Thread Dump");
                \u26035.func_71507_a("Threads", \u26033);
                File \u26036 = new File(new File(this.field_180249_b.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                if (crashReport.func_147149_a(\u26036)) {
                    field_180251_a.error("This crash report has been saved to: {}", (Object)\u26036.getAbsolutePath());
                } else {
                    field_180251_a.error("We were unable to save this crash report to disk.");
                }
                this.func_180248_a();
            }
            try {
                Thread.sleep(l + this.field_180250_c - \u2603);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void func_180248_a() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().halt(1);
        }
    }
}

