/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractArrowEntity
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> field_184554_g = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187203_m);
    private static final DataParameter<Byte> field_213876_as = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    @Nullable
    private BlockState field_195056_av;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    public UUID field_70250_c;
    private int field_70252_j;
    private int field_70257_an;
    private double field_70255_ao = 2.0;
    private int field_70256_ap;
    private SoundEvent field_213877_ay = this.func_213867_k();
    private IntOpenHashSet field_213878_az;
    private List<Entity> field_213875_aA;

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> entityType, World world) {
        super(entityType, world);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> entityType, double d, double d2, double d3, World world) {
        this(entityType, world);
        this.func_70107_b(d, d2, d3);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> entityType, LivingEntity livingEntity, World world) {
        this(entityType, livingEntity.field_70165_t, livingEntity.field_70163_u + (double)livingEntity.func_70047_e() - (double)0.1f, livingEntity.field_70161_v, world);
        this.func_212361_a(livingEntity);
        if (livingEntity instanceof PlayerEntity) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    public void func_213869_a(SoundEvent soundEvent) {
        this.field_213877_ay = soundEvent;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184554_g, (byte)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
        this.field_70180_af.func_187214_a(field_213876_as, (byte)0);
    }

    public void func_184547_a(Entity entity, float f, float f2, float f3, float f4, float f5) {
        \u2603 = -MathHelper.func_76126_a(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(f * ((float)Math.PI / 180));
        \u2603 = -MathHelper.func_76126_a(f * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76134_b(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(f * ((float)Math.PI / 180));
        this.func_70186_c(\u2603, \u2603, \u2603, f4, f5);
        this.func_213317_d(this.func_213322_ci().func_72441_c(entity.func_213322_ci().field_72450_a, entity.field_70122_E ? 0.0 : entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c));
    }

    @Override
    public void func_70186_c(double d, double d2, double d3, float f, float f2) {
        Vec3d vec3d = new Vec3d(d, d2, d3).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2).func_186678_a(f);
        this.func_213317_d(vec3d);
        float \u26032 = MathHelper.func_76133_a(AbstractArrowEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b(vec3d.field_72450_a, vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(vec3d.field_72448_b, \u26032) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70252_j = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_70071_h_() {
        VoxelShape \u26033;
        BlockPos blockPos;
        BlockState blockState;
        super.func_70071_h_();
        boolean bl = this.func_203047_q();
        Vec3d \u26032 = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a(AbstractArrowEntity.func_213296_b(\u26032));
            this.field_70177_z = (float)(MathHelper.func_181159_b(\u26032.field_72450_a, \u26032.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b(\u26032.field_72448_b, f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockState = this.field_70170_p.func_180495_p(blockPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_196958_f() || bl || (\u26033 = blockState.func_196952_d(this.field_70170_p, blockPos)).func_197766_b())) {
            for (AxisAlignedBB axisAlignedBB : \u26033.func_197756_d()) {
                if (!axisAlignedBB.func_186670_a(blockPos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !bl) {
            if (this.field_195056_av != blockState && this.field_70170_p.func_217351_c(this.func_174813_aQ().func_186662_g(0.06))) {
                this.field_70254_i = false;
                this.func_213317_d(\u26032.func_216372_d(this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f));
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_203048_f();
            }
            ++this.field_184552_b;
            return;
        }
        this.field_184552_b = 0;
        ++this.field_70257_an;
        Vec3d \u26035 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d \u26034 = \u26035.func_178787_e(\u26032);
        BlockRayTraceResult blockRayTraceResult = this.field_70170_p.func_217299_a(new RayTraceContext(\u26035, \u26034, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
        if (((RayTraceResult)blockRayTraceResult).func_216346_c() != RayTraceResult.Type.MISS) {
            \u26034 = blockRayTraceResult.func_216347_e();
        }
        while (!this.field_70128_L) {
            void var7_14;
            void var7_12;
            EntityRayTraceResult entityRayTraceResult = this.func_213866_a(\u26035, \u26034);
            if (entityRayTraceResult != null) {
                EntityRayTraceResult entityRayTraceResult2 = entityRayTraceResult;
            }
            if (var7_12 != null && var7_12.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)var7_12).func_216348_a();
                Entity entity2 = this.func_212360_k();
                if (entity instanceof PlayerEntity && entity2 instanceof PlayerEntity && !((PlayerEntity)entity2).func_96122_a((PlayerEntity)entity)) {
                    Object var7_13 = null;
                    entityRayTraceResult = null;
                }
            }
            if (var7_14 != null && !bl) {
                this.func_184549_a((RayTraceResult)var7_14);
                this.field_70160_al = true;
            }
            if (entityRayTraceResult == null || this.func_213874_s() <= 0) break;
            Object var7_15 = null;
        }
        \u26032 = this.func_213322_ci();
        double d = \u26032.field_72450_a;
        double d2 = \u26032.field_72448_b;
        \u2603 = \u26032.field_72449_c;
        if (this.func_70241_g()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a(ParticleTypes.field_197614_g, this.field_70165_t + d * (double)i / 4.0, this.field_70163_u + d2 * (double)i / 4.0, this.field_70161_v + \u2603 * (double)i / 4.0, -d, -d2 + 0.2, -\u2603);
            }
        }
        this.field_70165_t += d;
        this.field_70163_u += d2;
        this.field_70161_v += \u2603;
        float \u26036 = MathHelper.func_76133_a(AbstractArrowEntity.func_213296_b(\u26032));
        this.field_70177_z = bl ? (float)(MathHelper.func_181159_b(-d, -\u2603) * 57.2957763671875) : (float)(MathHelper.func_181159_b(d, \u2603) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(d2, \u26036) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g(0.2f, this.field_70127_C, this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g(0.2f, this.field_70126_B, this.field_70177_z);
        float \u26037 = 0.99f;
        float \u26038 = 0.05f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f = 0.25f;
                this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, this.field_70165_t - d * 0.25, this.field_70163_u - d2 * 0.25, this.field_70161_v - \u2603 * 0.25, d, d2, \u2603);
            }
            \u26037 = this.func_203044_p();
        }
        this.func_213317_d(\u26032.func_186678_a(\u26037));
        if (!this.func_189652_ae() && !bl) {
            Vec3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a, vec3d.field_72448_b - (double)0.05f, vec3d.field_72449_c);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void func_203048_f() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.func_70106_y();
        }
    }

    protected void func_184549_a(RayTraceResult rayTraceResult) {
        RayTraceResult.Type type = rayTraceResult.func_216346_c();
        if (type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)rayTraceResult);
        } else if (type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            this.field_195056_av = \u2603 = this.field_70170_p.func_180495_p(blockRayTraceResult.func_216350_a());
            Vec3d \u26032 = blockRayTraceResult.func_216347_e().func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_213317_d(\u26032);
            Vec3d \u26033 = \u26032.func_72432_b().func_186678_a(0.05f);
            this.field_70165_t -= \u26033.field_72450_a;
            this.field_70163_u -= \u26033.field_72448_b;
            this.field_70161_v -= \u26033.field_72449_c;
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            this.func_213872_b((byte)0);
            this.func_213869_a(SoundEvents.field_187731_t);
            this.func_213865_o(false);
            this.func_213870_w();
            \u2603.func_215690_a(this.field_70170_p, \u2603, blockRayTraceResult, this);
        }
    }

    private void func_213870_w() {
        if (this.field_213875_aA != null) {
            this.field_213875_aA.clear();
        }
        if (this.field_213878_az != null) {
            this.field_213878_az.clear();
        }
    }

    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        DamageSource \u26034;
        Entity entity = entityRayTraceResult.func_216348_a();
        float \u26032 = (float)this.func_213322_ci().func_72433_c();
        int \u26033 = MathHelper.func_76143_f(Math.max((double)\u26032 * this.field_70255_ao, 0.0));
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() < this.func_213874_s() + 1) {
                this.field_213878_az.add(entity.func_145782_y());
            } else {
                this.func_70106_y();
                return;
            }
        }
        if (this.func_70241_g()) {
            \u26033 += this.field_70146_Z.nextInt(\u26033 / 2 + 2);
        }
        if ((entity2 = this.func_212360_k()) == null) {
            \u26034 = DamageSource.func_76353_a(this, this);
        } else {
            Entity entity2;
            \u26034 = DamageSource.func_76353_a(this, entity2);
            if (entity2 instanceof LivingEntity) {
                ((LivingEntity)entity2).func_130011_c(entity);
            }
        }
        int n = entity.func_223314_ad();
        if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(\u26034, \u26033)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingEntity.func_85034_r(livingEntity.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && ((Vec3d)(object = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6))).func_189985_c() > 0.0) {
                    livingEntity.func_70024_g(((Vec3d)object).field_72450_a, 0.1, ((Vec3d)object).field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity2 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a(livingEntity, entity2);
                    EnchantmentHelper.func_151385_b((LivingEntity)entity2, livingEntity);
                }
                this.func_184548_a(livingEntity);
                if (entity2 != null && livingEntity != entity2 && livingEntity instanceof PlayerEntity && entity2 instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity2).field_71135_a.func_147359_a(new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingEntity);
                }
                if (!this.field_70170_p.field_72995_K && entity2 instanceof ServerPlayerEntity) {
                    Object object = (ServerPlayerEntity)entity2;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a((ServerPlayerEntity)object, this.field_213875_aA, this.field_213875_aA.size());
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a((ServerPlayerEntity)object, Arrays.asList(entity), 0);
                    }
                }
            }
            this.func_184185_a(this.field_213877_ay, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0 && !(entity instanceof EndermanEntity)) {
                this.func_70106_y();
            }
        } else {
            entity.func_223308_g(n);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent func_203050_i() {
        return this.field_213877_ay;
    }

    protected void func_184548_a(LivingEntity livingEntity) {
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d vec3d, Vec3d vec3d2) {
        return ProjectileHelper.func_221271_a(this.field_70170_p, this, vec3d, vec3d2, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> !(entity.func_175149_v() || !entity.func_70089_S() || !entity.func_70067_L() || entity == this.func_212360_k() && this.field_70257_an < 5 || this.field_213878_az != null && this.field_213878_az.contains(entity.func_145782_y())));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74777_a("life", (short)this.field_70252_j);
        if (this.field_195056_av != null) {
            compoundNBT.func_218657_a("inBlockState", NBTUtil.func_190009_a(this.field_195056_av));
        }
        compoundNBT.func_74774_a("shake", (byte)this.field_70249_b);
        compoundNBT.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        compoundNBT.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        compoundNBT.func_74780_a("damage", this.field_70255_ao);
        compoundNBT.func_74757_a("crit", this.func_70241_g());
        compoundNBT.func_74774_a("PierceLevel", this.func_213874_s());
        if (this.field_70250_c != null) {
            compoundNBT.func_186854_a("OwnerUUID", this.field_70250_c);
        }
        compoundNBT.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c(this.field_213877_ay).toString());
        compoundNBT.func_74757_a("ShotFromCrossbow", this.func_213873_r());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.field_70252_j = compoundNBT.func_74765_d("life");
        if (compoundNBT.func_150297_b("inBlockState", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d(compoundNBT.func_74775_l("inBlockState"));
        }
        this.field_70249_b = compoundNBT.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = compoundNBT.func_74771_c("inGround") == 1;
        if (compoundNBT.func_150297_b("damage", 99)) {
            this.field_70255_ao = compoundNBT.func_74769_h("damage");
        }
        if (compoundNBT.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.func_188795_a(compoundNBT.func_74771_c("pickup"));
        } else if (compoundNBT.func_150297_b("player", 99)) {
            this.field_70251_a = compoundNBT.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(compoundNBT.func_74767_n("crit"));
        this.func_213872_b(compoundNBT.func_74771_c("PierceLevel"));
        if (compoundNBT.func_186855_b("OwnerUUID")) {
            this.field_70250_c = compoundNBT.func_186857_a("OwnerUUID");
        }
        if (compoundNBT.func_150297_b("SoundEvent", 8)) {
            this.field_213877_ay = Registry.field_212633_v.func_218349_b(new ResourceLocation(compoundNBT.func_74779_i("SoundEvent"))).orElse(this.func_213867_k());
        }
        this.func_213865_o(compoundNBT.func_74767_n("ShotFromCrossbow"));
    }

    public void func_212361_a(@Nullable Entity entity) {
        UUID uUID = this.field_70250_c = entity == null ? null : entity.func_110124_au();
        if (entity instanceof PlayerEntity) {
            this.field_70251_a = ((PlayerEntity)entity).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    @Nullable
    public Entity func_212360_k() {
        if (this.field_70250_c != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.field_70250_c);
        }
        return null;
    }

    @Override
    public void func_70100_b_(PlayerEntity playerEntity) {
        boolean bl;
        if (this.field_70170_p.field_72995_K || !this.field_70254_i && !this.func_203047_q() || this.field_70249_b > 0) {
            return;
        }
        boolean bl2 = bl = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && playerEntity.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_212360_k().func_110124_au() == playerEntity.func_110124_au();
        if (this.field_70251_a == PickupStatus.ALLOWED && !playerEntity.field_71071_by.func_70441_a(this.func_184550_j())) {
            bl = false;
        }
        if (bl) {
            playerEntity.func_71001_a(this, 1);
            this.func_70106_y();
        }
    }

    protected abstract ItemStack func_184550_j();

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70239_b(double d) {
        this.field_70255_ao = d;
    }

    public double func_70242_d() {
        return this.field_70255_ao;
    }

    public void func_70240_a(int n) {
        this.field_70256_ap = n;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    protected float func_213316_a(Pose pose, EntitySize entitySize) {
        return 0.0f;
    }

    public void func_70243_d(boolean bl) {
        this.func_203049_a(1, bl);
    }

    public void func_213872_b(byte by) {
        this.field_70180_af.func_187227_b(field_213876_as, by);
    }

    private void func_203049_a(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184554_g);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(by | n));
        } else {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(by & ~n));
        }
    }

    public boolean func_70241_g() {
        byte by = this.field_70180_af.func_187225_a(field_184554_g);
        return (by & 1) != 0;
    }

    public boolean func_213873_r() {
        byte by = this.field_70180_af.func_187225_a(field_184554_g);
        return (by & 4) != 0;
    }

    public byte func_213874_s() {
        return this.field_70180_af.func_187225_a(field_213876_as);
    }

    public void func_190547_a(LivingEntity livingEntity, float f) {
        int n = EnchantmentHelper.func_185284_a(Enchantments.field_185309_u, livingEntity);
        \u2603 = EnchantmentHelper.func_185284_a(Enchantments.field_185310_v, livingEntity);
        this.func_70239_b((double)(f * 2.0f) + (this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f)));
        if (n > 0) {
            this.func_70239_b(this.func_70242_d() + (double)n * 0.5 + 0.5);
        }
        if (\u2603 > 0) {
            this.func_70240_a(\u2603);
        }
        if (EnchantmentHelper.func_185284_a(Enchantments.field_185311_w, livingEntity) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean bl) {
        this.field_70145_X = bl;
        this.func_203049_a(2, bl);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return (this.field_70180_af.func_187225_a(field_184554_g) & 2) != 0;
    }

    public void func_213865_o(boolean bl) {
        this.func_203049_a(4, bl);
    }

    @Override
    public IPacket<?> func_213297_N() {
        Entity entity = this.func_212360_k();
        return new SSpawnObjectPacket(this, entity == null ? 0 : entity.func_145782_y());
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int n) {
            if (n < 0 || n > PickupStatus.values().length) {
                n = 0;
            }
            return PickupStatus.values()[n];
        }
    }
}

