/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.blocks.infuser;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.Infusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.blocks.infuser.MachineInfuserConfiguration;
import mcjty.rftoolsbase.blocks.infuser.MachineInfuserSetup;
import mcjty.rftoolsbase.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MachineInfuserTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((IItemProvider)ModItems.DIMENSIONALSHARD)}), "container", 0, 64, 24, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_OUTPUT, new ItemStack[0]), "container", 1, 118, 24, 1, 18, 1, 18);
            this.layoutPlayerInventorySlots(10, 70);
        }
    };
    private LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(this::createItemHandler);
    private LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MachineInfuserConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MachineInfuserConfiguration.RECEIVEPERTICK.get()).intValue()));
    private int infusing = 0;

    public MachineInfuserTileEntity() {
        super(MachineInfuserSetup.TYPE_INFUSER);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickServer();
        }
    }

    private void tickServer() {
        this.itemHandler.ifPresent(h -> {
            if (this.infusing > 0) {
                --this.infusing;
                if (this.infusing == 0) {
                    ItemStack outputStack = h.getStackInSlot(1);
                    this.finishInfusing(outputStack);
                }
                this.markDirtyQuick();
            } else {
                ItemStack inputStack = h.getStackInSlot(0);
                ItemStack outputStack = h.getStackInSlot(1);
                if (!inputStack.func_190926_b() && inputStack.func_77973_b() == ModItems.DIMENSIONALSHARD && this.isInfusable(outputStack)) {
                    this.startInfusing();
                }
            }
        });
    }

    private boolean isInfusable(ItemStack stack) {
        return MachineInfuserTileEntity.getTagCompound(stack).map(tagCompound -> {
            int infused = tagCompound.func_74762_e("infused");
            return infused < (Integer)MachineInfuserConfiguration.MAX_INFUSE.get();
        }).orElse(false);
    }

    @Nonnull
    private static Optional<CompoundNBT> getTagCompound(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return Optional.empty();
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        Block block = ((BlockItem)item).func_179223_d();
        if (!(block instanceof Infusable || block instanceof BaseBlock && ((BaseBlock)block).isInfusable())) {
            return Optional.empty();
        }
        return Optional.of(stack.func_196082_o());
    }

    private void finishInfusing(ItemStack stack) {
        MachineInfuserTileEntity.getTagCompound(stack).ifPresent(tagCompound -> {
            int infused = tagCompound.func_74762_e("infused");
            tagCompound.func_74768_a("infused", infused + 1);
            stack.func_77982_d(tagCompound);
        });
    }

    private void startInfusing() {
        this.energyHandler.ifPresent(energy -> {
            int rf = (Integer)MachineInfuserConfiguration.RFPERTICK.get();
            rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
            if (energy.getEnergy() < (long)rf) {
                return;
            }
            energy.consumeEnergy((long)rf);
            this.itemHandler.ifPresent(h -> {
                h.getStackInSlot(0).func_77979_a(1);
                if (h.getStackInSlot(0).func_190926_b()) {
                    h.setStackInSlot(0, ItemStack.field_190927_a);
                }
            });
            this.infusing = 5;
            this.markDirtyQuick();
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, CONTAINER_FACTORY, 2){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot != 0 || stack.func_77973_b() == ModItems.DIMENSIONALSHARD;
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return CONTAINER_FACTORY.isInputSlot(slot) || CONTAINER_FACTORY.isSpecificItemSlot(slot);
            }

            public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
                return CONTAINER_FACTORY.isOutputSlot(slot);
            }
        };
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.ifPresent(h -> h.deserializeNBT(tagCompound.func_150295_c("Items", 10)));
        this.energyHandler.ifPresent(h -> h.setEnergy(tagCompound.func_74763_f("Energy")));
        this.infusing = tagCompound.func_74762_e("infusing");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.itemHandler.ifPresent(h -> tagCompound.func_218657_a("Items", (INBT)h.serializeNBT()));
        this.energyHandler.ifPresent(h -> tagCompound.func_74772_a("Energy", h.getEnergy()));
        tagCompound.func_74768_a("infusing", this.infusing);
        return tagCompound;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        GenericContainer container = new GenericContainer(MachineInfuserSetup.CONTAINER_INFUSER, windowId, CONTAINER_FACTORY, this.func_174877_v());
        this.itemHandler.ifPresent(h -> container.setupInventories((IItemHandler)h, inventory));
        this.energyHandler.ifPresent(e -> e.addIntegerListeners(container));
        return container;
    }
}

