/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.biome.BOPBiomes;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProviderSettings;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.feature.structure.Structure;

public class BOPEndBiomeProvider
extends BiomeProvider {
    private final SimplexNoiseGenerator generator;
    private final SharedSeedRandom random;
    private final Biome[] field_205009_d = new Biome[]{Biomes.field_76779_k, Biomes.field_201938_R, Biomes.field_201937_Q, Biomes.field_201936_P, Biomes.field_201939_S, BOPBiomes.dead_reef.get(), BOPBiomes.ethereal_forest.get()};

    public BOPEndBiomeProvider(EndBiomeProviderSettings p_i48970_1_) {
        this.random = new SharedSeedRandom(p_i48970_1_.func_205445_a());
        this.random.func_202423_a(17292);
        this.generator = new SimplexNoiseGenerator((Random)this.random);
    }

    public Biome func_201545_a(int p_201545_1_, int p_201545_2_) {
        int lvt_3_1_ = p_201545_1_ >> 4;
        int lvt_4_1_ = p_201545_2_ >> 4;
        if ((long)lvt_3_1_ * (long)lvt_3_1_ + (long)lvt_4_1_ * (long)lvt_4_1_ <= 4096L) {
            return Biomes.field_76779_k;
        }
        float lvt_5_1_ = this.func_222365_c(lvt_3_1_ * 2 + 1, lvt_4_1_ * 2 + 1);
        if (lvt_5_1_ > 40.0f) {
            return BOPBiomes.ethereal_forest.get();
        }
        if (lvt_5_1_ >= 0.0f) {
            return Biomes.field_201937_Q;
        }
        return lvt_5_1_ < -20.0f ? Biomes.field_201936_P : Biomes.field_201939_S;
    }

    public Biome[] func_201537_a(int p_201537_1_, int p_201537_2_, int p_201537_3_, int p_201537_4_, boolean p_201537_5_) {
        Biome[] lvt_6_1_ = new Biome[p_201537_3_ * p_201537_4_];
        Long2ObjectOpenHashMap lvt_7_1_ = new Long2ObjectOpenHashMap();
        for (int lvt_8_1_ = 0; lvt_8_1_ < p_201537_3_; ++lvt_8_1_) {
            for (int lvt_9_1_ = 0; lvt_9_1_ < p_201537_4_; ++lvt_9_1_) {
                int lvt_10_1_ = lvt_8_1_ + p_201537_1_;
                int lvt_11_1_ = lvt_9_1_ + p_201537_2_;
                long lvt_12_1_ = ChunkPos.func_77272_a((int)lvt_10_1_, (int)lvt_11_1_);
                Biome lvt_14_1_ = (Biome)lvt_7_1_.get(lvt_12_1_);
                if (lvt_14_1_ == null) {
                    lvt_14_1_ = this.func_201545_a(lvt_10_1_, lvt_11_1_);
                    lvt_7_1_.put(lvt_12_1_, (Object)lvt_14_1_);
                }
                lvt_6_1_[lvt_8_1_ + lvt_9_1_ * p_201537_3_] = lvt_14_1_;
            }
        }
        return lvt_6_1_;
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        return Sets.newHashSet((Object[])this.func_201539_b(i, j, i1, j1));
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.func_201539_b(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public float func_222365_c(int p_222365_1_, int p_222365_2_) {
        int lvt_3_1_ = p_222365_1_ / 2;
        int lvt_4_1_ = p_222365_2_ / 2;
        int lvt_5_1_ = p_222365_1_ % 2;
        int lvt_6_1_ = p_222365_2_ % 2;
        float lvt_7_1_ = 100.0f - MathHelper.func_76129_c((float)(p_222365_1_ * p_222365_1_ + p_222365_2_ * p_222365_2_)) * 8.0f;
        lvt_7_1_ = MathHelper.func_76131_a((float)lvt_7_1_, (float)-100.0f, (float)80.0f);
        for (int lvt_8_1_ = -12; lvt_8_1_ <= 12; ++lvt_8_1_) {
            for (int lvt_9_1_ = -12; lvt_9_1_ <= 12; ++lvt_9_1_) {
                long lvt_10_1_ = lvt_3_1_ + lvt_8_1_;
                long lvt_12_1_ = lvt_4_1_ + lvt_9_1_;
                if (lvt_10_1_ * lvt_10_1_ + lvt_12_1_ * lvt_12_1_ <= 4096L || !(this.generator.func_151605_a((double)lvt_10_1_, (double)lvt_12_1_) < (double)-0.9f)) continue;
                float lvt_14_1_ = (MathHelper.func_76135_e((float)lvt_10_1_) * 3439.0f + MathHelper.func_76135_e((float)lvt_12_1_) * 147.0f) % 13.0f + 9.0f;
                float lvt_15_1_ = lvt_5_1_ - lvt_8_1_ * 2;
                float lvt_16_1_ = lvt_6_1_ - lvt_9_1_ * 2;
                float lvt_17_1_ = 100.0f - MathHelper.func_76129_c((float)(lvt_15_1_ * lvt_15_1_ + lvt_16_1_ * lvt_16_1_)) * lvt_14_1_;
                lvt_17_1_ = MathHelper.func_76131_a((float)lvt_17_1_, (float)-100.0f, (float)80.0f);
                lvt_7_1_ = Math.max(lvt_7_1_, lvt_17_1_);
            }
        }
        return lvt_7_1_;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205008_1_ -> {
            for (Biome biome : this.field_205009_d) {
                if (!biome.func_201858_a(p_205008_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.field_205009_d) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }
}

