/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.generator.AbstractGeneratorTileEntity;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractFluidFuelGeneratorTileEntity
extends AbstractGeneratorTileEntity {
    public static final int FIELDS_COUNT = 8;
    protected final FluidTank tank;
    private final LazyOptional<IFluidHandler> fluidHandlerCap;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractFluidFuelGeneratorTileEntity.this.redstoneMode.ordinal();
                }
                case 5: {
                    return AbstractFluidFuelGeneratorTileEntity.this.burnTime;
                }
                case 6: {
                    return AbstractFluidFuelGeneratorTileEntity.this.totalBurnTime;
                }
                case 7: {
                    return AbstractFluidFuelGeneratorTileEntity.this.tank.getFluidAmount();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractFluidFuelGeneratorTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                    break;
                }
                case 5: {
                    AbstractFluidFuelGeneratorTileEntity.this.burnTime = value;
                    break;
                }
                case 6: {
                    AbstractFluidFuelGeneratorTileEntity.this.totalBurnTime = value;
                    break;
                }
                case 7: {
                    FluidStack fluid = AbstractFluidFuelGeneratorTileEntity.this.tank.getFluid();
                    AbstractFluidFuelGeneratorTileEntity.this.tank.setFluid(new FluidStack(fluid.getFluid(), value));
                }
            }
        }

        public int func_221478_a() {
            return 8;
        }
    };

    protected AbstractFluidFuelGeneratorTileEntity(TileEntityType<?> typeIn, int inventorySize, int maxEnergy, int maxReceive, int maxExtract, FluidTank tankIn) {
        super(typeIn, inventorySize, maxEnergy, maxReceive, maxExtract);
        this.tank = tankIn;
        this.fluidHandlerCap = LazyOptional.of(() -> this.tank);
    }

    @Override
    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        if (tags.func_74764_b("FluidTank")) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l("FluidTank")));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags.func_218657_a("FluidTank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        if (tags.func_74764_b("FluidTank")) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l("FluidTank")));
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        tags.func_218657_a("FluidTank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return tags;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.fluidHandlerCap.invalidate();
    }
}

