/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.capability.EnergyStorageImpl;

public interface IEnergyHandler {
    public EnergyStorageImpl getEnergyImpl();

    default public LazyOptional<IEnergyStorage> getEnergy(@Nullable Direction side) {
        return this.getEnergyImpl().getCapability(CapabilityEnergy.ENERGY, side);
    }

    default public int getEnergyStored() {
        return ((IEnergyStorage)this.getEnergy(null).orElseThrow(IllegalStateException::new)).getEnergyStored();
    }

    default public int getMaxEnergyStored() {
        return ((IEnergyStorage)this.getEnergy(null).orElseThrow(IllegalStateException::new)).getMaxEnergyStored();
    }

    default public void setEnergyStoredDirectly(int value) {
        this.getEnergy(null).ifPresent(e -> {
            if (e instanceof EnergyStorageImpl) {
                ((EnergyStorageImpl)((Object)e)).setEnergyDirectly(value);
            }
        });
    }

    default public void readEnergy(CompoundNBT tags) {
        this.setEnergyStoredDirectly(tags.func_74762_e("Energy"));
    }

    default public void writeEnergy(CompoundNBT tags) {
        tags.func_74768_a("Energy", this.getEnergyStored());
    }
}

