/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.lang.annotation.ElementType;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotationVisitor;
import net.minecraftforge.fml.loading.moddiscovery.ModFieldVisitor;
import net.minecraftforge.fml.loading.moddiscovery.ModMethodVisitor;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModClassVisitor
extends ClassVisitor {
    private Type asmType;
    private Type asmSuperType;
    private Set<Type> interfaces;
    private final LinkedList<ModAnnotation> annotations = new LinkedList();

    public ModClassVisitor() {
        super(327680);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.asmType = Type.getObjectType((String)name);
        this.asmSuperType = superName != null && superName.length() > 0 ? Type.getObjectType((String)superName) : null;
        this.interfaces = Stream.of(interfaces).map(Type::getObjectType).collect(Collectors.toSet());
    }

    public AnnotationVisitor visitAnnotation(String annotationName, boolean runtimeVisible) {
        ModAnnotation ann = new ModAnnotation(ElementType.TYPE, Type.getType((String)annotationName), this.asmType.getClassName());
        this.annotations.addFirst(ann);
        return new ModAnnotationVisitor(this.annotations, ann);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new ModFieldVisitor(name, this.annotations);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new ModMethodVisitor(name, desc, this.annotations);
    }

    public void buildData(Set<ModFileScanData.ClassData> classes, Set<ModFileScanData.AnnotationData> annotations) {
        classes.add(new ModFileScanData.ClassData(this.asmType, this.asmSuperType, this.interfaces));
        List collect = this.annotations.stream().filter(ma -> ModFileScanData.interestingAnnotations().test(ma.asmType)).map(a -> ModAnnotation.fromModAnnotation(this.asmType, a)).collect(Collectors.toList());
        annotations.addAll(collect);
    }
}

