/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.item;

import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.item.ItemBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ItemSeedBag
extends ItemBase
implements INamedContainerProvider {
    public ItemSeedBag(String name) {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName("bluepower:" + name);
    }

    public static ItemStack getSeedType(ItemStack seedBag) {
        ItemStack seed = ItemStack.field_190927_a;
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        if (seedBag.func_77942_o()) {
            seedBagInvHandler.deserializeNBT(seedBag.func_77978_p().func_74775_l("inv"));
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack is = seedBagInvHandler.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            seed = is;
        }
        return seed;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getItemDamageForDisplay(stack) / 576.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public int getItemDamageForDisplay(ItemStack stack) {
        int items = 0;
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        if (stack.func_77942_o()) {
            seedBagInvHandler.deserializeNBT(stack.func_77978_p().func_74775_l("inv"));
        }
        for (int i = 0; i < 8; ++i) {
            ItemStack is = seedBagInvHandler.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            items += is.func_190916_E();
        }
        return items;
    }

    public int getMaxDamage(ItemStack stack) {
        return 576;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        if (!world.field_72995_K && player.func_70093_af()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(handIn));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World worldIn = context.func_195991_k();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        if (player.func_70093_af()) {
            return ActionResultType.PASS;
        }
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        Hand activeHand = Hand.MAIN_HAND;
        ItemStack seedBag = player.func_184586_b(activeHand);
        if (!(seedBag.func_77973_b() instanceof ItemSeedBag)) {
            seedBag = player.func_184592_cb();
            activeHand = Hand.OFF_HAND;
        }
        if (seedBag.func_77942_o()) {
            seedBagInvHandler.deserializeNBT(seedBag.func_77978_p().func_74775_l("inv"));
        }
        ItemStack seed = ItemSeedBag.getSeedType(player.func_184586_b(hand));
        Block block = Block.func_149634_a((Item)seed.func_77973_b());
        if (!seed.func_190926_b() && block instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            BlockState b = worldIn.func_180495_p(pos);
            if (b.func_177230_c().canSustainPlant(b, (IBlockReader)worldIn, pos, Direction.UP, plant) && worldIn.func_175623_d(pos.func_177972_a(Direction.UP))) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = seedBagInvHandler.getStackInSlot(i);
                    if (is.func_190926_b()) continue;
                    worldIn.func_180501_a(pos.func_177972_a(Direction.UP), block.func_176223_P(), 0);
                    seedBagInvHandler.extractItem(i, 1, false);
                    break;
                }
                if (!seedBag.func_77942_o()) {
                    seedBag.func_77982_d(new CompoundNBT());
                }
                if (seedBag.func_77978_p() != null) {
                    seedBag.func_77978_p().func_218657_a("inv", (INBT)seedBagInvHandler.serializeNBT());
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("seed_bag");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerSeedBag(id, inventory);
    }
}

