/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.request;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.data.ItemStackMatcher;
import com.lothrazar.storagenetwork.api.util.UtilTileEntity;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.block.request.SlotCraftingNetwork;
import com.lothrazar.storagenetwork.block.request.TileRequest;
import com.lothrazar.storagenetwork.gui.ContainerNetworkBase;
import com.lothrazar.storagenetwork.gui.InventoryCraftingNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ContainerRequest
extends ContainerNetworkBase {
    private final TileRequest tileRequest;

    public ContainerRequest(int windowId, World world, BlockPos pos, PlayerInventory playerInv, PlayerEntity player) {
        super(SsnRegistry.requestcontainer, windowId);
        this.tileRequest = (TileRequest)world.func_175625_s(pos);
        this.matrix = new InventoryCraftingNetwork((Container)this, this.tileRequest.matrix);
        this.playerInv = playerInv;
        SlotCraftingNetwork slotCraftOutput = new SlotCraftingNetwork(this, playerInv.field_70458_d, this.matrix, (IInventory)this.resultInventory, 0, 101, 128);
        slotCraftOutput.setTileMaster(this.getTileMaster());
        this.func_75146_a((Slot)slotCraftOutput);
        this.bindGrid();
        this.bindPlayerInvo(playerInv);
        this.bindHotbar();
        this.func_75130_a((IInventory)this.matrix);
    }

    @Override
    public void bindHotbar() {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInv, i, 8 + i * 18, 232));
        }
    }

    @Override
    public void func_75130_a(IInventory inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        super.func_75130_a(inventoryIn);
    }

    @Override
    public void slotChanged() {
        for (int i = 0; i < 9; ++i) {
            this.getTileRequest().matrix.put(i, this.matrix.func_70301_a(i));
        }
        UtilTileEntity.updateTile(this.getTileRequest().func_145831_w(), this.getTileRequest().func_174877_v());
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        BlockPos pos;
        TileMaster tileMaster = this.getTileMaster();
        TileRequest table = this.getTileRequest();
        if (tileMaster != null && !table.func_145831_w().field_72995_K && table.func_145831_w().func_82737_E() % 40L == 0L) {
            List<ItemStack> list = tileMaster.getStacks();
        }
        return playerIn.func_70092_e((double)(pos = table.func_174877_v()).func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.result && super.func_94530_a(stack, slot);
    }

    @Override
    public TileMaster getTileMaster() {
        if (this.getTileRequest() == null || this.getTileRequest().getMaster() == null) {
            return null;
        }
        return this.getTileRequest().getMaster().getTileEntity(TileMaster.class);
    }

    TileRequest getTileRequest() {
        return this.tileRequest;
    }

    public static boolean isRequest() {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int slotIndex) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            TileMaster tileMaster = this.getTileMaster();
            if (slotIndex == 0) {
                this.craftShift(playerIn, tileMaster);
                return ItemStack.field_190927_a;
            }
            if (tileMaster != null) {
                int rest = tileMaster.insertStack(itemstack1, false);
                ItemStack stack = rest == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)rest);
                slot.func_75215_d(stack);
                this.func_75142_b();
                List<ItemStack> list = tileMaster.getStacks();
                if (playerIn instanceof ServerPlayerEntity) {
                    ServerPlayerEntity sp = (ServerPlayerEntity)playerIn;
                    PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), sp.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected static void func_217066_a(int p_217066_0_, World p_217066_1_, PlayerEntity p_217066_2_, CraftingInventory p_217066_3_, CraftResultInventory p_217066_4_) {
        if (!p_217066_1_.field_72995_K) {
            ICraftingRecipe lvt_8_1_;
            ServerPlayerEntity lvt_5_1_ = (ServerPlayerEntity)p_217066_2_;
            ItemStack lvt_6_1_ = ItemStack.field_190927_a;
            Optional lvt_7_1_ = p_217066_1_.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)p_217066_3_, p_217066_1_);
            if (lvt_7_1_.isPresent() && p_217066_4_.func_201561_a(p_217066_1_, lvt_5_1_, (IRecipe)(lvt_8_1_ = (ICraftingRecipe)lvt_7_1_.get()))) {
                lvt_6_1_ = lvt_8_1_.func_77572_b((IInventory)p_217066_3_);
            }
            p_217066_4_.func_70299_a(0, lvt_6_1_);
            lvt_5_1_.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(p_217066_0_, 0, lvt_6_1_));
        }
    }

    protected void craftShift(PlayerEntity player, TileMaster tile) {
        if (this.matrix == null) {
            return;
        }
        this.recipeCurrent = null;
        this.findMatchingRecipeClient(player.field_70170_p, this.matrix, this.resultInventory);
        if (this.recipeCurrent == null) {
            return;
        }
        this.recipeLocked = true;
        int crafted = 0;
        ArrayList recipeCopy = Lists.newArrayList();
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            recipeCopy.add(this.matrix.func_70301_a(i).func_77946_l());
        }
        ItemStack res = this.recipeCurrent.func_77572_b((IInventory)this.matrix);
        if (res.func_190926_b()) {
            StorageNetwork.LOGGER.info("err Recipe output is an empty stack " + this.recipeCurrent);
            return;
        }
        int sizePerCraft = res.func_190916_E();
        StorageNetwork.log("[craftShift] sizePerCraft = " + sizePerCraft + " for stack " + res);
        while (crafted + sizePerCraft <= res.func_77976_d()) {
            res = this.recipeCurrent.func_77572_b((IInventory)this.matrix);
            StorageNetwork.log("[craftShift]  crafted = " + crafted + " ; res.count() = " + res.func_190916_E() + " MAX=" + res.func_77976_d());
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInv), (ItemStack)res, (boolean)true).func_190926_b()) {
                StorageNetwork.log("[craftShift] cannot insert more, end");
                break;
            }
            if (!this.recipeCurrent.func_77569_a((IInventory)this.matrix, player.field_70170_p)) {
                StorageNetwork.log("[craftShift] recipe doesnt match i quit");
                break;
            }
            StorageNetwork.log("[craftShift] addItemStackToInventory " + res);
            if (!player.field_71071_by.func_70441_a(res)) {
                player.func_71019_a(res, false);
            }
            NonNullList remainder = this.recipeCurrent.func_179532_b((IInventory)this.matrix);
            StorageNetwork.log("[craftShift] getRemainingItems " + remainder);
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack remainderCurrent = (ItemStack)remainder.get(i);
                ItemStack slot = this.matrix.func_70301_a(i);
                if (remainderCurrent.func_190926_b()) {
                    StorageNetwork.log("[craftShift] getRemainingItems  set empty " + i);
                    this.matrix.func_70301_a(i).func_190918_g(1);
                    continue;
                }
                if (slot.func_77973_b().func_77668_q() != null) {
                    slot = new ItemStack((IItemProvider)slot.func_77973_b().func_77668_q());
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!slot.func_77973_b().getContainerItem(slot).func_190926_b()) {
                    slot = slot.func_77973_b().getContainerItem(slot);
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!remainderCurrent.func_190926_b()) {
                    StorageNetwork.log("[craftShift] NONEMPTY " + remainderCurrent);
                    if (slot.func_190926_b()) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_179545_c((ItemStack)slot, (ItemStack)remainderCurrent) && ItemStack.func_77970_a((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        remainderCurrent.func_190917_f(slot.func_190916_E());
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_185132_d((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (player.field_71071_by.func_70441_a(remainderCurrent)) continue;
                    player.func_71019_a(remainderCurrent, false);
                    continue;
                }
                if (slot.func_190926_b()) continue;
                this.matrix.func_70298_a(i, 1);
                slot = this.matrix.func_70301_a(i);
            }
            crafted += sizePerCraft;
            for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.matrix.func_70301_a(i);
                if (!stackInSlot.func_190926_b()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackMatcher itemStackMatcherCurrent = !recipeStack.func_190926_b() ? new ItemStackMatcher(recipeStack, false, false) : null;
                ItemStack req = tile.request(itemStackMatcherCurrent, 1, false);
                this.matrix.func_70299_a(i, req);
            }
            this.func_75130_a((IInventory)this.matrix);
        }
        this.func_75142_b();
        this.recipeLocked = false;
        this.func_75130_a((IInventory)this.matrix);
    }
}

