/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ThrowableEntity
extends Entity
implements IProjectile {
    private int field_145788_c = -1;
    private int field_145786_d = -1;
    private int field_145787_e = -1;
    protected boolean field_174854_a;
    public int field_70191_b;
    protected LivingEntity field_70192_c;
    private UUID field_200218_h;
    private Entity field_184539_c;
    private int field_184540_av;

    protected ThrowableEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected ThrowableEntity(EntityType<? extends ThrowableEntity> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected ThrowableEntity(EntityType<? extends ThrowableEntity> type, LivingEntity livingEntityIn, World worldIn) {
        this(type, livingEntityIn.field_70165_t, livingEntityIn.field_70163_u + (double)livingEntityIn.func_70047_e() - (double)0.1f, livingEntityIn.field_70161_v, worldIn);
        this.field_70192_c = livingEntityIn;
        this.field_200218_h = livingEntityIn.func_110124_au();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vec3d vec3d = entityThrower.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, entityThrower.field_70122_E ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a(velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)ThrowableEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @Override
    public void func_70071_h_() {
        float f1;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.field_174854_a) {
            this.field_174854_a = false;
            this.func_213317_d(this.func_213322_ci().func_216372_d(this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f));
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        for (Entity entity : this.field_70170_p.func_175674_a(this, axisalignedbb, p_213881_0_ -> !p_213881_0_.func_175149_v() && p_213881_0_.func_70067_L())) {
            if (entity == this.field_184539_c) {
                ++this.field_184540_av;
                break;
            }
            if (this.field_70192_c == null || this.field_70173_aa >= 2 || this.field_184539_c != null) continue;
            this.field_184539_c = entity;
            this.field_184540_av = 3;
            break;
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)axisalignedbb, p_213880_1_ -> !p_213880_1_.func_175149_v() && p_213880_1_.func_70067_L() && p_213880_1_ != this.field_184539_c, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (this.field_184539_c != null && this.field_184540_av-- <= 0) {
            this.field_184539_c = null;
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70184_a(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        this.field_70165_t += vec3d.field_72450_a;
        this.field_70163_u += vec3d.field_72448_b;
        this.field_70161_v += vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)ThrowableEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - vec3d.field_72450_a * 0.25, this.field_70163_u - vec3d.field_72448_b * 0.25, this.field_70161_v - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            f1 = 0.8f;
        } else {
            f1 = 0.99f;
        }
        this.func_213317_d(vec3d.func_186678_a(f1));
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.func_70185_h(), vec3d1.field_72449_c);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected abstract void func_70184_a(RayTraceResult var1);

    @Override
    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("xTile", this.field_145788_c);
        compound.func_74768_a("yTile", this.field_145786_d);
        compound.func_74768_a("zTile", this.field_145787_e);
        compound.func_74774_a("shake", (byte)this.field_70191_b);
        compound.func_74774_a("inGround", (byte)(this.field_174854_a ? 1 : 0));
        if (this.field_200218_h != null) {
            compound.func_218657_a("owner", NBTUtil.func_186862_a((UUID)this.field_200218_h));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.field_145788_c = compound.func_74762_e("xTile");
        this.field_145786_d = compound.func_74762_e("yTile");
        this.field_145787_e = compound.func_74762_e("zTile");
        this.field_70191_b = compound.func_74771_c("shake") & 0xFF;
        this.field_174854_a = compound.func_74771_c("inGround") == 1;
        this.field_70192_c = null;
        if (compound.func_150297_b("owner", 10)) {
            this.field_200218_h = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("owner"));
        }
    }

    @Nullable
    public LivingEntity func_85052_h() {
        if (this.field_70192_c == null && this.field_200218_h != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.field_200218_h);
            if (entity instanceof LivingEntity) {
                this.field_70192_c = (LivingEntity)entity;
            } else {
                this.field_200218_h = null;
            }
        }
        return this.field_70192_c;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

