/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockModel
implements IUnbakedModel {
    private static final Logger field_178313_f = LogManager.getLogger();
    private static final FaceBakery field_217647_g = new FaceBakery();
    @VisibleForTesting
    static final Gson field_178319_a = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> field_178314_g;
    private final boolean field_178321_h;
    public final boolean field_178322_i;
    private final ItemCameraTransforms field_178320_j;
    private final List<ItemOverride> field_187968_k;
    public String field_178317_b = "";
    @VisibleForTesting
    public final Map<String, String> field_178318_c;
    @Nullable
    public BlockModel field_178315_d;
    @Nullable
    protected ResourceLocation field_178316_e;

    public static BlockModel func_178307_a(Reader readerIn) {
        return (BlockModel)JSONUtils.func_193839_a((Gson)field_178319_a, (Reader)readerIn, BlockModel.class);
    }

    public static BlockModel func_178294_a(String jsonString) {
        return BlockModel.func_178307_a(new StringReader(jsonString));
    }

    public BlockModel(@Nullable ResourceLocation parentLocationIn, List<BlockPart> elementsIn, Map<String, String> texturesIn, boolean ambientOcclusionIn, boolean gui3dIn, ItemCameraTransforms cameraTransformsIn, List<ItemOverride> overridesIn) {
        this.field_178314_g = elementsIn;
        this.field_178322_i = ambientOcclusionIn;
        this.field_178321_h = gui3dIn;
        this.field_178318_c = texturesIn;
        this.field_178316_e = parentLocationIn;
        this.field_178320_j = cameraTransformsIn;
        this.field_187968_k = overridesIn;
    }

    public List<BlockPart> func_178298_a() {
        return this.field_178314_g.isEmpty() && this.field_178315_d != null ? this.field_178315_d.func_178298_a() : this.field_178314_g;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.field_178316_e;
    }

    public boolean func_178309_b() {
        return this.field_178315_d != null ? this.field_178315_d.func_178309_b() : this.field_178322_i;
    }

    public boolean func_178311_c() {
        return this.field_178321_h;
    }

    public List<ItemOverride> func_187966_f() {
        return this.field_187968_k;
    }

    private ItemOverrideList func_217646_a(ModelBakery p_217646_1_, BlockModel p_217646_2_) {
        return this.field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(p_217646_1_, p_217646_2_, p_217646_1_::func_209597_a, this.field_187968_k);
    }

    public ItemOverrideList getOverrides(ModelBakery p_217646_1_, BlockModel p_217646_2_, Function<ResourceLocation, TextureAtlasSprite> textureGetter, VertexFormat format) {
        return this.field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(p_217646_1_, p_217646_2_, p_217646_1_::func_209597_a, textureGetter, this.field_187968_k, format);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.field_187968_k) {
            set.add(itemoverride.func_188026_a());
        }
        if (this.field_178316_e != null) {
            set.add(this.field_178316_e);
        }
        return set;
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockModel blockmodel = this;
        while (blockmodel.field_178316_e != null && blockmodel.field_178315_d == null) {
            set.add(blockmodel);
            IUnbakedModel iunbakedmodel = modelGetter.apply(blockmodel.field_178316_e);
            if (iunbakedmodel == null) {
                field_178313_f.warn("No parent '{}' while loading model '{}'", (Object)this.field_178316_e, (Object)blockmodel);
            }
            if (set.contains(iunbakedmodel)) {
                field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)blockmodel, (Object)set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)this.field_178316_e);
                iunbakedmodel = null;
            }
            if (iunbakedmodel == null) {
                blockmodel.field_178316_e = ModelBakery.field_177604_a;
                iunbakedmodel = modelGetter.apply(blockmodel.field_178316_e);
            }
            if (!(iunbakedmodel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            blockmodel = blockmodel.field_178315_d = (BlockModel)iunbakedmodel;
        }
        HashSet set1 = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation(this.func_178308_c("particle"))});
        for (BlockPart blockpart : this.func_178298_a()) {
            for (BlockPartFace blockpartface : blockpart.field_178240_c.values()) {
                String s = this.func_178308_c(blockpartface.field_178242_d);
                if (Objects.equals(s, MissingTextureSprite.func_195675_b().toString())) {
                    missingTextureErrors.add(String.format("%s in %s", blockpartface.field_178242_d, this.field_178317_b));
                }
                set1.add(new ResourceLocation(s));
            }
        }
        this.field_187968_k.forEach(p_217643_4_ -> {
            IUnbakedModel iunbakedmodel1 = (IUnbakedModel)modelGetter.apply(p_217643_4_.func_188026_a());
            if (!Objects.equals(iunbakedmodel1, this)) {
                set1.addAll(iunbakedmodel1.func_209559_a(modelGetter, missingTextureErrors));
            }
        });
        if (this.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(p_217642_2_ -> set1.add(new ResourceLocation(this.func_178308_c((String)p_217642_2_))));
        }
        return set1;
    }

    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
            throw new IllegalArgumentException("Cannot bake vanilla model to format other than BLOCK");
        }
        return this.bake(bakery, this, spriteGetter, sprite, format);
    }

    @Deprecated
    public IBakedModel func_217644_a(ModelBakery p_217644_1_, BlockModel p_217644_2_, Function<ResourceLocation, TextureAtlasSprite> p_217644_3_, ISprite p_217644_4_) {
        return this.bake(p_217644_1_, p_217644_2_, p_217644_3_, p_217644_4_, DefaultVertexFormats.field_176599_b);
    }

    public IBakedModel bake(ModelBakery p_217644_1_, BlockModel p_217644_2_, Function<ResourceLocation, TextureAtlasSprite> p_217644_3_, ISprite p_217644_4_, VertexFormat format) {
        TextureAtlasSprite textureatlassprite = p_217644_3_.apply(new ResourceLocation(this.func_178308_c("particle")));
        if (this.func_178310_f() == ModelBakery.field_177616_r) {
            return new BuiltInModel(this.func_181682_g(), this.getOverrides(p_217644_1_, p_217644_2_, p_217644_3_, format), textureatlassprite);
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.getOverrides(p_217644_1_, p_217644_2_, p_217644_3_, format)).func_177646_a(textureatlassprite);
        for (BlockPart blockpart : this.func_178298_a()) {
            for (Direction direction : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get((Object)direction);
                TextureAtlasSprite textureatlassprite1 = p_217644_3_.apply(new ResourceLocation(this.func_178308_c(blockpartface.field_178242_d)));
                if (blockpartface.field_178244_b == null) {
                    simplebakedmodel$builder.func_177648_a(BlockModel.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, direction, p_217644_4_));
                    continue;
                }
                simplebakedmodel$builder.func_177650_a(p_217644_4_.getState().apply(Optional.empty()).map(trsr -> trsr.rotateTransform(blockpartface.field_178244_b)).orElse(blockpartface.field_178244_b), BlockModel.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, direction, p_217644_4_));
            }
        }
        return simplebakedmodel$builder.func_177645_b();
    }

    private static BakedQuad func_217645_a(BlockPart p_217645_0_, BlockPartFace p_217645_1_, TextureAtlasSprite p_217645_2_, Direction p_217645_3_, ISprite p_217645_4_) {
        return field_217647_g.func_217648_a(p_217645_0_.field_178241_a, p_217645_0_.field_178239_b, p_217645_1_, p_217645_2_, p_217645_3_, p_217645_4_, p_217645_0_.field_178237_d, p_217645_0_.field_178238_e);
    }

    public static BakedQuad makeBakedQuad(BlockPart p_209567_0, BlockPartFace partFace, TextureAtlasSprite sprite, Direction face, ISprite isprite) {
        return field_217647_g.makeBakedQuad(p_209567_0.field_178241_a, p_209567_0.field_178239_b, partFace, sprite, face, (ISprite)new BasicState((IModelState)isprite.getState().apply(Optional.empty()).orElse(TRSRTransformation.identity()), isprite.func_188049_c()), p_209567_0.field_178237_d, p_209567_0.field_178238_e);
    }

    public boolean func_178300_b(String textureName) {
        return !MissingTextureSprite.func_195675_b().toString().equals(this.func_178308_c(textureName));
    }

    public String func_178308_c(String textureName) {
        if (!this.func_178304_d(textureName)) {
            textureName = '#' + textureName;
        }
        return this.func_178302_a(textureName, new Bookkeep(this));
    }

    private String func_178302_a(String textureName, Bookkeep p_178302_2_) {
        if (this.func_178304_d(textureName)) {
            if (this == p_178302_2_.field_178323_b) {
                field_178313_f.warn("Unable to resolve texture due to upward reference: {} in {}", (Object)textureName, (Object)this.field_178317_b);
                return MissingTextureSprite.func_195675_b().toString();
            }
            String s = this.field_178318_c.get(textureName.substring(1));
            if (s == null && this.field_178315_d != null) {
                s = this.field_178315_d.func_178302_a(textureName, p_178302_2_);
            }
            p_178302_2_.field_178323_b = this;
            if (s != null && this.func_178304_d(s)) {
                s = p_178302_2_.field_178324_a.func_178302_a(s, p_178302_2_);
            }
            return s != null && !this.func_178304_d(s) ? s : MissingTextureSprite.func_195675_b().toString();
        }
        return textureName;
    }

    private boolean func_178304_d(String hash) {
        return hash.charAt(0) == '#';
    }

    public BlockModel func_178310_f() {
        return this.field_178315_d == null ? this : this.field_178315_d.func_178310_f();
    }

    public ItemCameraTransforms func_181682_g() {
        ItemTransformVec3f itemtransformvec3f = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f1 = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f2 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f3 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f4 = this.func_181681_a(ItemCameraTransforms.TransformType.HEAD);
        ItemTransformVec3f itemtransformvec3f5 = this.func_181681_a(ItemCameraTransforms.TransformType.GUI);
        ItemTransformVec3f itemtransformvec3f6 = this.func_181681_a(ItemCameraTransforms.TransformType.GROUND);
        ItemTransformVec3f itemtransformvec3f7 = this.func_181681_a(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemtransformvec3f, itemtransformvec3f1, itemtransformvec3f2, itemtransformvec3f3, itemtransformvec3f4, itemtransformvec3f5, itemtransformvec3f6, itemtransformvec3f7);
    }

    private ItemTransformVec3f func_181681_a(ItemCameraTransforms.TransformType type) {
        return this.field_178315_d != null && !this.field_178320_j.func_181687_c(type) ? this.field_178315_d.func_181681_a(type) : this.field_178320_j.func_181688_b(type);
    }

    public String toString() {
        return this.field_178317_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            List<BlockPart> list = this.func_178325_a(p_deserialize_3_, jsonobject);
            String s = this.func_178326_c(jsonobject);
            Map<String, String> map = this.func_178329_b(jsonobject);
            boolean flag = this.func_178328_a(jsonobject);
            ItemCameraTransforms itemcameratransforms = ItemCameraTransforms.field_178357_a;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"display");
                itemcameratransforms = (ItemCameraTransforms)p_deserialize_3_.deserialize((JsonElement)jsonobject1, ItemCameraTransforms.class);
            }
            List<ItemOverride> list1 = this.func_187964_a(p_deserialize_3_, jsonobject);
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new BlockModel(resourcelocation, list, map, flag, true, itemcameratransforms, list1);
        }

        protected List<ItemOverride> func_187964_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("overrides")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"overrides")) {
                    list.add(deserializationContext.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, String> func_178329_b(JsonObject object) {
            HashMap map = Maps.newHashMap();
            if (object.has("textures")) {
                JsonObject jsonobject = JSONUtils.func_152754_s((JsonObject)object, (String)"textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            return map;
        }

        private String func_178326_c(JsonObject object) {
            return JSONUtils.func_151219_a((JsonObject)object, (String)"parent", (String)"");
        }

        protected boolean func_178328_a(JsonObject object) {
            return JSONUtils.func_151209_a((JsonObject)object, (String)"ambientocclusion", (boolean)true);
        }

        protected List<BlockPart> func_178325_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("elements")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"elements")) {
                    list.add(deserializationContext.deserialize(jsonelement, BlockPart.class));
                }
            }
            return list;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class Bookkeep {
        public final BlockModel field_178324_a;
        public BlockModel field_178323_b;

        private Bookkeep(BlockModel modelIn) {
            this.field_178324_a = modelIn;
        }
    }
}

