/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5HeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlayerRenderer
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public PlayerRenderer(EntityRendererManager renderManager) {
        this(renderManager, false);
    }

    public PlayerRenderer(EntityRendererManager renderManager, boolean useSmallArms) {
        super(renderManager, new PlayerModel(0.0f, useSmallArms), 0.5f);
        this.func_177094_a(new BipedArmorLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>, BipedModel>(this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new HeldItemLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ArrowLayer((LivingRenderer)this));
        this.func_177094_a(new Deadmau5HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new CapeLayer((IEntityRenderer)this));
        this.func_177094_a(new HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new ElytraLayer((IEntityRenderer)this));
        this.func_177094_a(new ParrotVariantLayer((IEntityRenderer)this));
        this.func_177094_a(new SpinAttackEffectLayer((IEntityRenderer)this));
    }

    @Override
    public void func_76986_a(AbstractClientPlayerEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entity.func_175144_cb() || this.field_76990_c.field_217783_c.func_216773_g() == entity) {
            double d0 = y;
            if (MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Pre((PlayerEntity)entity, this, partialTicks, x, y, z))) {
                return;
            }
            if (entity.func_213287_bg()) {
                d0 = y - 0.125;
            }
            this.func_177137_d(entity);
            GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            super.func_76986_a(entity, x, d0, z, entityYaw, partialTicks);
            GlStateManager.unsetProfile((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Post((PlayerEntity)entity, this, partialTicks, x, y, z));
    }

    private void func_177137_d(AbstractClientPlayerEntity clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            playermodel.func_178719_a(true);
            playermodel.field_178720_f.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.HAT);
            playermodel.field_178730_v.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.JACKET);
            playermodel.field_178733_c.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.field_178731_d.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.field_178734_a.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.LEFT_SLEEVE);
            playermodel.field_178732_b.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.field_78117_n = clientPlayer.func_213287_bg();
            BipedModel.ArmPose bipedmodel$armpose = this.func_217766_a(clientPlayer, itemstack, itemstack1, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = this.func_217766_a(clientPlayer, itemstack, itemstack1, Hand.OFF_HAND);
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = bipedmodel$armpose;
                playermodel.field_187075_l = bipedmodel$armpose1;
            } else {
                playermodel.field_187076_m = bipedmodel$armpose1;
                playermodel.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    private BipedModel.ArmPose func_217766_a(AbstractClientPlayerEntity p_217766_1_, ItemStack p_217766_2_, ItemStack p_217766_3_, Hand p_217766_4_) {
        ItemStack itemstack;
        BipedModel.ArmPose bipedmodel$armpose = BipedModel.ArmPose.EMPTY;
        ItemStack itemStack = itemstack = p_217766_4_ == Hand.MAIN_HAND ? p_217766_2_ : p_217766_3_;
        if (!itemstack.func_190926_b()) {
            bipedmodel$armpose = BipedModel.ArmPose.ITEM;
            if (p_217766_1_.func_184605_cv() > 0) {
                UseAction useaction = itemstack.func_77975_n();
                if (useaction == UseAction.BLOCK) {
                    bipedmodel$armpose = BipedModel.ArmPose.BLOCK;
                } else if (useaction == UseAction.BOW) {
                    bipedmodel$armpose = BipedModel.ArmPose.BOW_AND_ARROW;
                } else if (useaction == UseAction.SPEAR) {
                    bipedmodel$armpose = BipedModel.ArmPose.THROW_SPEAR;
                } else if (useaction == UseAction.CROSSBOW && p_217766_4_ == p_217766_1_.func_184600_cs()) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                boolean flag3 = p_217766_2_.func_77973_b() == Items.field_222114_py;
                boolean flag = CrossbowItem.func_220012_d((ItemStack)p_217766_2_);
                boolean flag1 = p_217766_3_.func_77973_b() == Items.field_222114_py;
                boolean flag2 = CrossbowItem.func_220012_d((ItemStack)p_217766_3_);
                if (flag3 && flag) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
                if (flag1 && flag2 && p_217766_2_.func_77973_b().func_77661_b(p_217766_2_) == UseAction.NONE) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
            }
        }
        return bipedmodel$armpose;
    }

    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        return entity.func_110306_p();
    }

    @Override
    protected void func_77041_b(AbstractClientPlayerEntity entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        GlStateManager.scalef((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    protected void func_188296_a(AbstractClientPlayerEntity entityIn, double x, double y, double z, String name, double distanceSq) {
        Scoreboard scoreboard;
        ScoreObjective scoreobjective;
        if (distanceSq < 100.0 && (scoreobjective = (scoreboard = entityIn.func_96123_co()).func_96539_a(2)) != null) {
            Score score = scoreboard.func_96529_a(entityIn.func_195047_I_(), scoreobjective);
            this.func_147906_a(entityIn, score.func_96652_c() + " " + scoreobjective.func_96678_d().func_150254_d(), x, y, z, 64);
            y += (double)0.25875f;
        }
        super.func_188296_a((Entity)entityIn, x, y, z, name, distanceSq);
    }

    public void func_177138_b(AbstractClientPlayerEntity clientPlayer) {
        float f = 1.0f;
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        this.func_177137_d(clientPlayer);
        GlStateManager.enableBlend();
        playermodel.field_217112_c = 0.0f;
        playermodel.field_78117_n = false;
        playermodel.field_205061_a = 0.0f;
        playermodel.func_212844_a_((LivingEntity)clientPlayer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        playermodel.field_178723_h.field_78795_f = 0.0f;
        playermodel.field_178723_h.func_78785_a(0.0625f);
        playermodel.field_178732_b.field_78795_f = 0.0f;
        playermodel.field_178732_b.func_78785_a(0.0625f);
        GlStateManager.disableBlend();
    }

    public void func_177139_c(AbstractClientPlayerEntity clientPlayer) {
        float f = 1.0f;
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        this.func_177137_d(clientPlayer);
        GlStateManager.enableBlend();
        playermodel.field_78117_n = false;
        playermodel.field_217112_c = 0.0f;
        playermodel.field_205061_a = 0.0f;
        playermodel.func_212844_a_((LivingEntity)clientPlayer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        playermodel.field_178724_i.field_78795_f = 0.0f;
        playermodel.field_178724_i.func_78785_a(0.0625f);
        playermodel.field_178734_a.field_78795_f = 0.0f;
        playermodel.field_178734_a.func_78785_a(0.0625f);
        GlStateManager.disableBlend();
    }

    @Override
    protected void func_77043_a(AbstractClientPlayerEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                GlStateManager.rotatef((float)(f2 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            Vec3d vec3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b(vec3d1);
            double d1 = Entity.func_213296_b(vec3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.field_72450_a * vec3d.field_72450_a + vec3d1.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.field_72450_a * vec3d.field_72449_c - vec3d1.field_72449_c * vec3d.field_72450_a;
                GlStateManager.rotatef((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else if (f > 0.0f) {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            GlStateManager.rotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
            if (entityLiving.func_213314_bj()) {
                GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.3f);
            }
        } else {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

