/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockState;

public class BlockState
extends StateHolder<Block, BlockState>
implements IStateHolder<BlockState>,
IForgeBlockState {
    @Nullable
    private Cache field_215707_c;
    private final int field_215708_d;
    private final boolean field_215709_e;

    public BlockState(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> properties) {
        super((Object)blockIn, properties);
        this.field_215708_d = blockIn.func_149750_m(this);
        this.field_215709_e = blockIn.func_220074_n(this);
    }

    public void func_215692_c() {
        if (!this.func_177230_c().func_208619_r()) {
            this.field_215707_c = new Cache(this);
        }
    }

    public Block func_177230_c() {
        return (Block)((Object)this.field_206876_a);
    }

    public Material func_185904_a() {
        return this.func_177230_c().func_149688_o(this);
    }

    public boolean func_215688_a(IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return this.func_177230_c().func_220067_a(this, worldIn, pos, type);
    }

    public boolean func_200131_a(IBlockReader worldIn, BlockPos pos) {
        return this.field_215707_c != null ? this.field_215707_c.field_222500_d : this.func_177230_c().func_200123_i(this, worldIn, pos);
    }

    public int func_200016_a(IBlockReader worldIn, BlockPos pos) {
        return this.field_215707_c != null ? this.field_215707_c.field_222501_e : this.func_177230_c().func_200011_d(this, worldIn, pos);
    }

    public VoxelShape func_215702_a(IBlockReader worldIn, BlockPos pos, Direction directionIn) {
        return this.field_215707_c != null && this.field_215707_c.field_222502_f != null ? this.field_215707_c.field_222502_f[directionIn.ordinal()] : VoxelShapes.func_216387_a((VoxelShape)this.func_196951_e(worldIn, pos), (Direction)directionIn);
    }

    public boolean func_215704_f() {
        return this.field_215707_c == null || this.field_215707_c.field_222503_g;
    }

    public boolean func_215691_g() {
        return this.field_215709_e;
    }

    public int func_185906_d() {
        return this.field_215708_d;
    }

    @Deprecated
    public boolean func_196958_f() {
        return this.func_177230_c().func_196261_e(this);
    }

    @Deprecated
    public MaterialColor func_185909_g(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_180659_g(this, worldIn, pos);
    }

    public BlockState func_185907_a(Rotation rot) {
        return this.func_177230_c().func_185499_a(this, rot);
    }

    public BlockState func_185902_a(Mirror mirrorIn) {
        return this.func_177230_c().func_185471_a(this, mirrorIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_191057_i() {
        return this.func_177230_c().func_190946_v(this);
    }

    public BlockRenderType func_185901_i() {
        return this.func_177230_c().func_149645_b(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_215684_a(IEnviromentBlockReader reader, BlockPos pos) {
        return this.func_177230_c().func_220058_a(this, reader, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_215703_d(IBlockReader reader, BlockPos pos) {
        return this.func_177230_c().func_220080_a(this, reader, pos);
    }

    public boolean func_215686_e(IBlockReader reader, BlockPos pos) {
        return this.func_177230_c().func_220081_d(this, reader, pos);
    }

    public boolean func_185897_m() {
        return this.func_177230_c().func_149744_f(this);
    }

    public int func_185911_a(IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_177230_c().func_180656_a(this, blockAccess, pos, side);
    }

    public boolean func_185912_n() {
        return this.func_177230_c().func_149740_M(this);
    }

    public int func_185888_a(World worldIn, BlockPos pos) {
        return this.func_177230_c().func_180641_l(this, worldIn, pos);
    }

    public float func_185887_b(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_176195_g(this, worldIn, pos);
    }

    public float func_185903_a(PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_180647_a(this, player, worldIn, pos);
    }

    public int func_185893_b(IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_177230_c().func_176211_b(this, blockAccess, pos, side);
    }

    public PushReaction func_185905_o() {
        return this.func_177230_c().func_149656_h(this);
    }

    public boolean func_200015_d(IBlockReader worldIn, BlockPos pos) {
        return this.field_215707_c != null ? this.field_215707_c.field_222499_c : this.func_177230_c().func_200012_i(this, worldIn, pos);
    }

    public boolean func_200132_m() {
        return this.field_215707_c != null ? this.field_215707_c.field_222498_b : this.func_177230_c().func_200124_e(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200017_a(BlockState state, Direction face) {
        return this.func_177230_c().func_200122_a(this, state, face);
    }

    public VoxelShape func_196954_c(IBlockReader worldIn, BlockPos pos) {
        return this.func_215700_a(worldIn, pos, ISelectionContext.func_216377_a());
    }

    public VoxelShape func_215700_a(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_177230_c().func_220053_a(this, worldIn, pos, context);
    }

    public VoxelShape func_196952_d(IBlockReader worldIn, BlockPos pos) {
        return this.field_215707_c != null ? this.field_215707_c.field_225501_g : this.func_215685_b(worldIn, pos, ISelectionContext.func_216377_a());
    }

    public VoxelShape func_215685_b(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_177230_c().func_220071_b(this, worldIn, pos, context);
    }

    public VoxelShape func_196951_e(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_196247_c(this, worldIn, pos);
    }

    public VoxelShape func_199611_f(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_199600_g(this, worldIn, pos);
    }

    public final boolean func_215682_a(IBlockReader reader, BlockPos pos, Entity entityIn) {
        return Block.func_208061_a(this.func_215685_b(reader, pos, ISelectionContext.func_216374_a(entityIn)), Direction.UP);
    }

    public Vec3d func_191059_e(IBlockReader access, BlockPos pos) {
        return this.func_177230_c().func_190949_e(this, access, pos);
    }

    public boolean func_189547_a(World worldIn, BlockPos pos, int id, int param) {
        return this.func_177230_c().func_189539_a(this, worldIn, pos, id, param);
    }

    public void func_215697_a(World worldIn, BlockPos p_215697_2_, Block blockIn, BlockPos p_215697_4_, boolean isMoving) {
        this.func_177230_c().func_220069_a(this, worldIn, p_215697_2_, blockIn, p_215697_4_, isMoving);
    }

    public void func_196946_a(IWorld worldIn, BlockPos pos, int flags) {
        this.func_177230_c().func_196242_c(this, worldIn, pos, flags);
    }

    public void func_196948_b(IWorld worldIn, BlockPos pos, int flags) {
        this.func_177230_c().func_196248_b(this, worldIn, pos, flags);
    }

    public void func_215705_a(World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.func_177230_c().func_220082_b(this, worldIn, pos, oldState, isMoving);
    }

    public void func_196947_b(World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.func_177230_c().func_196243_a(this, worldIn, pos, newState, isMoving);
    }

    public void func_196940_a(World worldIn, BlockPos pos, Random random) {
        this.func_177230_c().func_196267_b(this, worldIn, pos, random);
    }

    public void func_196944_b(World worldIn, BlockPos pos, Random random) {
        this.func_177230_c().func_196265_a(this, worldIn, pos, random);
    }

    public void func_196950_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_177230_c().func_196262_a(this, worldIn, pos, entityIn);
    }

    public void func_215706_a(World worldIn, BlockPos pos, ItemStack stack) {
        this.func_177230_c().func_220062_a(this, worldIn, pos, stack);
    }

    public List<ItemStack> func_215693_a(LootContext.Builder builder) {
        return this.func_177230_c().func_220076_a(this, builder);
    }

    public boolean func_215687_a(World worldIn, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.func_177230_c().func_220051_a(this, worldIn, hit.func_216350_a(), player, handIn, hit);
    }

    public void func_196942_a(World worldIn, BlockPos pos, PlayerEntity player) {
        this.func_177230_c().func_196270_a(this, worldIn, pos, player);
    }

    public boolean func_215696_m(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_220060_c(this, worldIn, pos);
    }

    public BlockState func_196956_a(Direction face, BlockState queried, IWorld worldIn, BlockPos currentPos, BlockPos offsetPos) {
        return this.func_177230_c().func_196271_a(this, face, queried, worldIn, currentPos, offsetPos);
    }

    public boolean func_196957_g(IBlockReader worldIn, BlockPos pos, PathType type) {
        return this.func_177230_c().func_196266_a(this, worldIn, pos, type);
    }

    public boolean func_196953_a(BlockItemUseContext useContext) {
        return this.func_177230_c().func_196253_a(this, useContext);
    }

    public boolean func_196955_c(IWorldReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_196260_a(this, worldIn, pos);
    }

    public boolean func_202065_c(IBlockReader worldIn, BlockPos pos) {
        return this.func_177230_c().func_201783_b(this, worldIn, pos);
    }

    @Nullable
    public INamedContainerProvider func_215699_b(World worldIn, BlockPos pos) {
        return this.func_177230_c().func_220052_b(this, worldIn, pos);
    }

    public boolean func_203425_a(Tag<Block> tagIn) {
        return this.func_177230_c().func_203417_a(tagIn);
    }

    public IFluidState func_204520_s() {
        return this.func_177230_c().func_204507_t(this);
    }

    public boolean func_204519_t() {
        return this.func_177230_c().func_149653_t(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209533_a(BlockPos pos) {
        return this.func_177230_c().func_209900_a(this, pos);
    }

    public SoundType func_215695_r() {
        return this.func_177230_c().func_220072_p(this);
    }

    public void func_215690_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        this.func_177230_c().func_220066_a(worldIn, state, hit, projectile);
    }

    public boolean func_224755_d(IBlockReader p_224755_1_, BlockPos p_224755_2_, Direction p_224755_3_) {
        return this.field_215707_c != null ? this.field_215707_c.field_225493_i[p_224755_3_.ordinal()] : Block.func_220056_d(this, p_224755_1_, p_224755_2_, p_224755_3_);
    }

    public boolean func_224756_o(IBlockReader p_224756_1_, BlockPos p_224756_2_) {
        return this.field_215707_c != null ? this.field_215707_c.field_225494_j : Block.func_208062_a(this.func_196952_d(p_224756_1_, p_224756_2_));
    }

    public static <T> Dynamic<T> func_215689_a(DynamicOps<T> opsIn, BlockState state) {
        ImmutableMap immutablemap = state.func_206871_b();
        Object t = immutablemap.isEmpty() ? opsIn.createMap((Map)ImmutableMap.of((Object)opsIn.createString("Name"), (Object)opsIn.createString(Registry.field_212618_g.func_177774_c((Object)state.func_177230_c()).toString()))) : opsIn.createMap((Map)ImmutableMap.of((Object)opsIn.createString("Name"), (Object)opsIn.createString(Registry.field_212618_g.func_177774_c((Object)state.func_177230_c()).toString()), (Object)opsIn.createString("Properties"), (Object)opsIn.createMap(immutablemap.entrySet().stream().map(p_215683_1_ -> Pair.of((Object)opsIn.createString(((IProperty)p_215683_1_.getKey()).func_177701_a()), (Object)opsIn.createString(IStateHolder.func_215670_b((IProperty)((IProperty)p_215683_1_.getKey()), (Comparable)((Comparable)p_215683_1_.getValue()))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)))));
        return new Dynamic(opsIn, t);
    }

    public static <T> BlockState func_215698_a(Dynamic<T> dynamic) {
        DefaultedRegistry<Block> defaultedregistry = Registry.field_212618_g;
        Optional optional = dynamic.getElement("Name");
        DynamicOps dynamicops = dynamic.getOps();
        Block block = (Block)((Object)defaultedregistry.func_82594_a(new ResourceLocation(optional.flatMap(arg_0 -> ((DynamicOps)dynamicops).getStringValue(arg_0)).orElse("minecraft:air"))));
        Map map = dynamic.get("Properties").asMap(p_215701_0_ -> p_215701_0_.asString(""), p_215694_0_ -> p_215694_0_.asString(""));
        BlockState blockstate = block.func_176223_P();
        StateContainer<Block, BlockState> statecontainer = block.func_176194_O();
        for (Map.Entry entry : map.entrySet()) {
            String s = (String)entry.getKey();
            IProperty iproperty = statecontainer.func_185920_a(s);
            if (iproperty == null) continue;
            blockstate = (BlockState)IStateHolder.func_215671_a((IStateHolder)blockstate, (IProperty)iproperty, (String)s, (String)dynamic.toString(), (String)((String)entry.getValue()));
        }
        return blockstate;
    }

    static final class Cache {
        private static final Direction[] field_222497_a = Direction.values();
        private final boolean field_222498_b;
        private final boolean field_222499_c;
        private final boolean field_222500_d;
        private final int field_222501_e;
        private final VoxelShape[] field_222502_f;
        private final VoxelShape field_225501_g;
        private final boolean field_222503_g;
        private final boolean[] field_225493_i;
        private final boolean field_225494_j;

        private Cache(BlockState stateIn) {
            Block block = stateIn.func_177230_c();
            this.field_222498_b = block.func_200124_e(stateIn);
            this.field_222499_c = block.func_200012_i(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            this.field_222500_d = block.func_200123_i(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            this.field_222501_e = block.func_200011_d(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            if (!stateIn.func_200132_m()) {
                this.field_222502_f = null;
            } else {
                this.field_222502_f = new VoxelShape[field_222497_a.length];
                VoxelShape voxelshape = block.func_196247_c(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                Direction[] directionArray = field_222497_a;
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction direction = directionArray[i];
                    this.field_222502_f[direction.ordinal()] = VoxelShapes.func_216387_a((VoxelShape)voxelshape, (Direction)direction);
                }
            }
            this.field_225501_g = block.func_220071_b(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, ISelectionContext.func_216377_a());
            this.field_222503_g = Arrays.stream(Direction.Axis.values()).anyMatch(p_222491_1_ -> this.field_225501_g.func_197762_b(p_222491_1_) < 0.0 || this.field_225501_g.func_197758_c(p_222491_1_) > 1.0);
            this.field_225493_i = new boolean[6];
            for (Direction direction1 : field_222497_a) {
                this.field_225493_i[direction1.ordinal()] = Block.func_220056_d(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, direction1);
            }
            this.field_225494_j = Block.func_208062_a(stateIn.func_196952_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a));
        }
    }
}

