/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui.nbt;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.lib.client.gui.nbt.DisplayNBTList;
import net.silentchaos512.lib.util.NBTToJson;
import net.silentchaos512.lib.util.TextRenderUtils;

public class DisplayNBTScreen
extends Screen {
    final List<String> lines;
    private final CompoundNBT nbtCompound;
    private DisplayNBTList displayList;
    private ITextComponent header;

    public DisplayNBTScreen(CompoundNBT nbt, ITextComponent titleIn) {
        super(titleIn);
        this.lines = DisplayNBTScreen.formatNbt(nbt, 0);
        this.nbtCompound = nbt;
        this.header = this.title;
    }

    protected void init() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.func_71410_x();
        }
        this.addButton((Widget)new Button(5, 5, 100, 20, "Export to JSON", b -> {
            JsonObject json = NBTToJson.toJsonObject(this.nbtCompound);
            String message = NBTToJson.writeFile(json);
            this.header = new StringTextComponent(message);
        }));
        int scaledWidth = this.minecraft.field_195558_d.func_198107_o();
        this.displayList = new DisplayNBTList(this, this.minecraft, scaledWidth, this.height, 12, this.height - 12, 11);
        this.children.add(this.displayList);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        assert (this.minecraft != null);
        this.displayList.render(mouseX, mouseY, partialTicks);
        String titleStr = this.header.func_150254_d();
        int scaledWidth = this.minecraft.field_195558_d.func_198107_o();
        TextRenderUtils.renderScaled(this.font, titleStr, (scaledWidth - this.font.func_78256_a(titleStr)) / 2, 2, 1.0f, 0xFFFFFF, true);
        super.render(mouseX, mouseY, partialTicks);
    }

    private static List<String> formatNbt(CompoundNBT nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : nbt.func_150296_c()) {
            INBT inbt = nbt.func_74781_a(key);
            list.addAll(DisplayNBTScreen.formatNbt(key, inbt, depth + 1));
        }
        return list;
    }

    private static List<String> formatNbt(String key, INBT nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        String indentStr = DisplayNBTScreen.indent(depth);
        if (nbt instanceof CompoundNBT) {
            DisplayNBTScreen.formatCompound(key, (CompoundNBT)nbt, depth, list, indentStr);
        } else if (nbt instanceof CollectionNBT) {
            DisplayNBTScreen.formatList(key, (CollectionNBT)nbt, depth, list, indentStr);
        } else if (nbt instanceof NumberNBT) {
            DisplayNBTScreen.formatNumber(key, (NumberNBT)nbt, list, indentStr);
        } else if (nbt instanceof StringNBT) {
            String value = nbt.func_150285_a_();
            list.add(indentStr + DisplayNBTScreen.format(key, value, TextFormatting.GREEN));
        }
        return list;
    }

    private static void formatCompound(String key, CompoundNBT nbt, int depth, List<String> list, String indentStr) {
        if (nbt.isEmpty()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "{}", TextFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "{", TextFormatting.RESET));
            list.addAll(DisplayNBTScreen.formatNbt(nbt, depth + 1));
            list.add(indentStr + "}" + (key.isEmpty() ? "" : TextFormatting.DARK_GRAY + " #" + key));
        }
    }

    private static void formatList(String key, CollectionNBT nbt, int depth, List<String> list, String indentStr) {
        if (nbt.isEmpty()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "[]", TextFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "[", TextFormatting.RESET));
            for (INBT element : nbt) {
                list.addAll(DisplayNBTScreen.formatNbt("", element, depth + 1));
            }
            list.add(indentStr + "]" + (key.isEmpty() ? "" : TextFormatting.DARK_GRAY + " #" + key));
        }
    }

    private static void formatNumber(String key, NumberNBT nbt, List<String> list, String indentStr) {
        Number value = nbt.func_209908_j();
        String line = indentStr + DisplayNBTScreen.format(key, value, TextFormatting.LIGHT_PURPLE);
        if (value instanceof Integer) {
            line = line + TextFormatting.GRAY + String.format(" (0x%X)", value.intValue());
        }
        list.add(line);
    }

    private static String format(String key, Object value, TextFormatting valueFormat) {
        if (key.isEmpty()) {
            return valueFormat + value.toString();
        }
        return TextFormatting.GOLD + key + TextFormatting.RESET + ": " + valueFormat + value;
    }

    private static String indent(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

