/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config.adapter;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomlib.config.adapter.TypeAdapter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class PathTypeAdapter
implements TypeAdapter {
    private final boolean isArray;

    public PathTypeAdapter(boolean isArray) {
        this.isArray = isArray;
    }

    @Override
    public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
        if (!this.isArray) {
            return TRLUtils.getPath((String)config.get(name));
        }
        List list = (List)config.get(name);
        ArrayList<Path> values = new ArrayList<Path>(list.size());
        for (String element : list) {
            Path path = TRLUtils.getPath(element);
            if (path == null) continue;
            values.add(path);
        }
        return values.toArray(new Path[0]);
    }

    @Override
    public void setValue(CommentedFileConfig config, String name, Object value) {
        if (this.isArray) {
            config.set(name, Arrays.stream((Object[])value).map(this::asString).collect(Collectors.toList()));
        } else {
            config.set(name, (Object)this.asString(value));
        }
    }

    @Override
    public String asString(Object value) {
        return TRLUtils.toStringWithUnixPathSeparators((Path)value);
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }
}

