/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.gui.BooleanConfigOption;
import ovh.corail.tombstone.gui.ColorButtonHandler;
import ovh.corail.tombstone.gui.IntegerConfigOption;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.registry.ModBlocks;

public class GuiConfig
extends TBScreen {
    private static final ResourceLocation tablet = new ResourceLocation("tombstone", "textures/block/grave_plate.png");
    private TabConfig tab = TabConfig.GRAVE;
    private Widget buttonGraveTexture;
    private Widget buttonLeftArrow;
    private Widget buttonRightArrow;
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private ColorButtonHandler colorButtonHandler1;
    private ColorButtonHandler colorButtonHandler2;
    private ColorButtonHandler colorButtonHandler3;
    private boolean enhanced_tooltips;
    private boolean highlightGrave;
    private boolean skipRespawnScreen;
    private boolean showShadowStep;
    private boolean enableHalloweenEffect;
    private boolean dateInMCTime;
    private boolean displayKnowledgeMessage;
    private boolean equipElytraInPriority;
    private boolean showInfoOnEnchantment;
    private Widget[] misc1Buttons = new Widget[9];
    private int graveSkinRule;
    private int fogDensity;
    private ColorButtonHandler colorButtonHandler0;
    private Widget[] misc2Buttons = new Widget[3];

    GuiConfig() {
        super((ITextComponent)new StringTextComponent("Tombstone Config"));
    }

    @Override
    public void init() {
        super.init();
        this.buttons.clear();
        int posY = 0;
        for (TabConfig currentTab : TabConfig.values()) {
            this.addButton((Widget)new TBGuiButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, currentTab.name(), pressable -> {
                this.tab = currentTab;
                this.updateButtons();
            }));
            posY += 20;
        }
        this.addButton((Widget)new TBGuiButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, "SAVE", pressable -> this.saveConfig()));
        this.enhanced_tooltips = (Boolean)ConfigTombstone.client.showEnhancedTooltips.get();
        this.highlightGrave = (Boolean)ConfigTombstone.client.highlight.get();
        this.skipRespawnScreen = (Boolean)ConfigTombstone.client.skipRespawnScreen.get();
        this.showShadowStep = (Boolean)ConfigTombstone.client.showShadowStep.get();
        this.enableHalloweenEffect = (Boolean)ConfigTombstone.client.enableHalloweenEffect.get();
        this.dateInMCTime = (Boolean)ConfigTombstone.client.dateInMCTime.get();
        this.displayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
        this.equipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
        this.showInfoOnEnchantment = (Boolean)ConfigTombstone.client.showInfoOnEnchantment.get();
        this.misc1Buttons[0] = new BooleanConfigOption("Enhanced Tooltips", () -> this.enhanced_tooltips, b -> {
            this.enhanced_tooltips = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 36, 160);
        this.addButton(this.misc1Buttons[0]);
        this.misc1Buttons[1] = new BooleanConfigOption("Highlight Grave", () -> this.highlightGrave, b -> {
            this.highlightGrave = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 50, 160);
        this.addButton(this.misc1Buttons[1]);
        this.misc1Buttons[2] = new BooleanConfigOption("Skip Respawn Screen", () -> this.skipRespawnScreen, b -> {
            this.skipRespawnScreen = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 64, 160);
        this.addButton(this.misc1Buttons[2]);
        this.misc1Buttons[3] = new BooleanConfigOption("Show ShadowStep", () -> this.showShadowStep, b -> {
            this.showShadowStep = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 78, 160);
        this.addButton(this.misc1Buttons[3]);
        this.misc1Buttons[4] = new BooleanConfigOption("Enable Halloween Effect", () -> this.enableHalloweenEffect, b -> {
            this.enableHalloweenEffect = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 92, 160);
        this.addButton(this.misc1Buttons[4]);
        this.misc1Buttons[5] = new BooleanConfigOption("Date in MC Time", () -> this.dateInMCTime, b -> {
            this.dateInMCTime = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 106, 160);
        this.addButton(this.misc1Buttons[5]);
        this.misc1Buttons[6] = new BooleanConfigOption("Display Knowledge Message", () -> this.displayKnowledgeMessage, b -> {
            this.displayKnowledgeMessage = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 120, 160);
        this.addButton(this.misc1Buttons[6]);
        this.misc1Buttons[7] = new BooleanConfigOption("Equip Elytra in Priority", () -> this.equipElytraInPriority, b -> {
            this.equipElytraInPriority = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 134, 160);
        this.addButton(this.misc1Buttons[7]);
        this.misc1Buttons[8] = new BooleanConfigOption("Show Info on Enchantment", () -> this.showInfoOnEnchantment, b -> {
            this.showInfoOnEnchantment = b;
        }).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 148, 160);
        this.addButton(this.misc1Buttons[8]);
        this.graveSkinRule = ((ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get())).ordinal();
        this.fogDensity = ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal();
        this.misc2Buttons[0] = new IntegerConfigOption("Grave Skin", () -> this.graveSkinRule, b -> {
            this.graveSkinRule = b;
        }, ConfigTombstone.Client.GraveSkinRule.values().length - 1){

            @Override
            protected String getOptionName() {
                return this.func_216617_a() + ConfigTombstone.Client.GraveSkinRule.values()[this.get()].name();
            }
        }.func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 36, 160);
        this.addButton(this.misc2Buttons[0]);
        this.misc2Buttons[1] = new IntegerConfigOption("Fog Density", () -> this.fogDensity, b -> {
            this.fogDensity = b;
        }, ConfigTombstone.Client.FogDensity.values().length - 1){

            @Override
            protected String getOptionName() {
                return this.func_216617_a() + ConfigTombstone.Client.FogDensity.values()[this.get()].name();
            }
        }.func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 50, 160);
        this.addButton(this.misc2Buttons[1]);
        Integer color = (Integer)ConfigTombstone.client.particleCastingColor.get();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        this.colorButtonHandler0 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 100, this.guiTop + 96, 40, 4, r, g, b2, "particleCastingColor");
        this.graveModel = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
        this.marbleType = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
        this.buttonGraveTexture = new OptionSlider(this.getMinecraft().field_71474_y, this.guiLeft + 126, this.guiTop + 40, 30, 20, new SliderPercentageOption("texture", 0.0, 1.0, 1.0f, settings -> this.marbleType.ordinal(), (settings, d) -> {
            this.marbleType = BlockGraveMarble.MarbleType.byId(d.intValue());
        }, (settings, d) -> this.marbleType.func_176610_l()));
        this.addButton(this.buttonGraveTexture);
        this.buttonLeftArrow = new TBGuiButton(this.guiLeft + 10, this.guiTop + 140, 40, 20, "<-", pressable -> {
            do {
                this.graveModel = this.graveModel.getPrevious();
            } while (this.graveModel.isOnlyContributor() && !Helper.isContributor((PlayerEntity)this.getMinecraft().field_71439_g));
        });
        this.addButton(this.buttonLeftArrow);
        this.buttonRightArrow = new TBGuiButton(this.guiLeft + 116, this.guiTop + 140, 40, 20, "->", pressable -> {
            do {
                this.graveModel = this.graveModel.getNext();
            } while (this.graveModel.isOnlyContributor() && !Helper.isContributor((PlayerEntity)this.getMinecraft().field_71439_g));
        });
        this.addButton(this.buttonRightArrow);
        color = (Integer)ConfigTombstone.client.textColorRIP.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler1 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 57, 40, 4, r, g, b2, "ripText");
        color = (Integer)ConfigTombstone.client.textColorOwner.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler2 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 87, 40, 4, r, g, b2, "deathDateText");
        color = (Integer)ConfigTombstone.client.textColorDeathDate.get();
        r = color >> 16 & 0xFF;
        g = color >> 8 & 0xFF;
        b2 = color & 0xFF;
        this.colorButtonHandler3 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.guiLeft + 6, this.guiTop + 121, 40, 4, r, g, b2, "diedOnText");
        this.updateButtons();
    }

    private void saveConfig() {
        boolean valid = false;
        if (ConfigTombstone.client.favoriteGrave.get() != this.graveModel) {
            ConfigTombstone.client.favoriteGrave.set((Object)this.graveModel);
            ConfigTombstone.client.favoriteGrave.save();
            valid = true;
        }
        if (ConfigTombstone.client.favoriteGraveMarble.get() != this.marbleType) {
            ConfigTombstone.client.favoriteGraveMarble.set((Object)this.marbleType);
            ConfigTombstone.client.favoriteGraveMarble.save();
            valid = true;
        }
        int colorRip = this.colorButtonHandler1.getColor();
        if ((Integer)ConfigTombstone.client.textColorRIP.get() != colorRip) {
            ConfigTombstone.client.textColorRIP.set((Object)colorRip);
            ConfigTombstone.client.textColorRIP.save();
        }
        int colorOwner = this.colorButtonHandler2.getColor();
        if ((Integer)ConfigTombstone.client.textColorOwner.get() != colorOwner) {
            ConfigTombstone.client.textColorOwner.set((Object)colorOwner);
            ConfigTombstone.client.textColorOwner.save();
        }
        int colorDate = this.colorButtonHandler3.getColor();
        if ((Integer)ConfigTombstone.client.textColorDeathDate.get() != colorDate) {
            ConfigTombstone.client.textColorDeathDate.set((Object)colorDate);
            ConfigTombstone.client.textColorDeathDate.save();
        }
        if ((Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != this.enhanced_tooltips) {
            ConfigTombstone.client.showEnhancedTooltips.set((Object)this.enhanced_tooltips);
            ConfigTombstone.client.showEnhancedTooltips.save();
        }
        if ((Boolean)ConfigTombstone.client.highlight.get() != this.highlightGrave) {
            ConfigTombstone.client.highlight.set((Object)this.highlightGrave);
            ConfigTombstone.client.highlight.save();
        }
        if ((Boolean)ConfigTombstone.client.skipRespawnScreen.get() != this.skipRespawnScreen) {
            ConfigTombstone.client.skipRespawnScreen.set((Object)this.skipRespawnScreen);
            ConfigTombstone.client.skipRespawnScreen.save();
        }
        if ((Boolean)ConfigTombstone.client.showShadowStep.get() != this.showShadowStep) {
            ConfigTombstone.client.showShadowStep.set((Object)this.showShadowStep);
            ConfigTombstone.client.showShadowStep.save();
        }
        if ((Boolean)ConfigTombstone.client.enableHalloweenEffect.get() != this.enableHalloweenEffect) {
            ConfigTombstone.client.enableHalloweenEffect.set((Object)this.enableHalloweenEffect);
            ConfigTombstone.client.enableHalloweenEffect.save();
        }
        if ((Boolean)ConfigTombstone.client.dateInMCTime.get() != this.dateInMCTime) {
            ConfigTombstone.client.dateInMCTime.set((Object)this.dateInMCTime);
            ConfigTombstone.client.dateInMCTime.save();
        }
        if ((Boolean)ConfigTombstone.client.displayKnowledgeMessage.get() != this.displayKnowledgeMessage) {
            ConfigTombstone.client.displayKnowledgeMessage.set((Object)this.displayKnowledgeMessage);
            ConfigTombstone.client.displayKnowledgeMessage.save();
            valid = true;
        }
        if ((Boolean)ConfigTombstone.client.equipElytraInPriority.get() != this.equipElytraInPriority) {
            ConfigTombstone.client.equipElytraInPriority.set((Object)this.equipElytraInPriority);
            ConfigTombstone.client.equipElytraInPriority.save();
            valid = true;
        }
        if ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get() != this.showInfoOnEnchantment) {
            ConfigTombstone.client.showInfoOnEnchantment.set((Object)this.showInfoOnEnchantment);
            ConfigTombstone.client.showInfoOnEnchantment.save();
        }
        if (((ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get())).ordinal() != this.graveSkinRule) {
            ConfigTombstone.client.graveSkinRule.set((Object)ConfigTombstone.Client.GraveSkinRule.values()[this.graveSkinRule]);
            ConfigTombstone.client.graveSkinRule.save();
        }
        if (((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal() != this.fogDensity) {
            ConfigTombstone.client.fogDensity.set((Object)ConfigTombstone.Client.FogDensity.values()[this.fogDensity]);
            ConfigTombstone.client.fogDensity.save();
        }
        int colorParticle = this.colorButtonHandler0.getColor();
        if ((Integer)ConfigTombstone.client.particleCastingColor.get() != colorParticle) {
            ConfigTombstone.client.particleCastingColor.set((Object)colorParticle);
            ConfigTombstone.client.particleCastingColor.save();
        }
        if (valid) {
            PacketHandler.sendToServer(new UpdateServerMessage(this.graveModel, this.marbleType, (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), false));
        }
        this.getMinecraft().field_71439_g.func_71053_j();
    }

    private void updateButtons() {
        switch (this.tab) {
            case GRAVE: {
                this.enableGraveButtons();
                this.disableColorButtons();
                this.disableMisc1Buttons();
                this.disableMisc2Buttons();
                break;
            }
            case PLATE: {
                this.enableColorButtons();
                this.disableGraveButtons();
                this.disableMisc1Buttons();
                this.disableMisc2Buttons();
                break;
            }
            case MISC1: {
                this.enableMisc1Buttons();
                this.disableGraveButtons();
                this.disableColorButtons();
                this.disableMisc2Buttons();
                break;
            }
            case MISC2: {
                this.enableMisc2Buttons();
                this.disableGraveButtons();
                this.disableColorButtons();
                this.disableMisc1Buttons();
            }
        }
    }

    private void enableGraveButtons() {
        this.buttonGraveTexture.active = true;
        this.buttonGraveTexture.visible = true;
        this.buttonLeftArrow.active = true;
        this.buttonLeftArrow.visible = true;
        this.buttonRightArrow.active = true;
        this.buttonRightArrow.visible = true;
    }

    private void disableGraveButtons() {
        this.buttonGraveTexture.active = false;
        this.buttonGraveTexture.visible = false;
        this.buttonLeftArrow.active = false;
        this.buttonLeftArrow.visible = false;
        this.buttonRightArrow.active = false;
        this.buttonRightArrow.visible = false;
    }

    private void enableColorButtons() {
        this.colorButtonHandler1.enableButtons();
        this.colorButtonHandler2.enableButtons();
        this.colorButtonHandler3.enableButtons();
    }

    private void disableColorButtons() {
        this.colorButtonHandler1.disableButtons();
        this.colorButtonHandler2.disableButtons();
        this.colorButtonHandler3.disableButtons();
    }

    private void enableMisc1Buttons() {
        for (Widget widget : this.misc1Buttons) {
            if (widget == null) continue;
            widget.active = true;
            widget.visible = true;
        }
    }

    private void disableMisc1Buttons() {
        for (Widget widget : this.misc1Buttons) {
            if (widget == null) continue;
            widget.active = false;
            widget.visible = false;
        }
    }

    private void enableMisc2Buttons() {
        for (Widget widget : this.misc2Buttons) {
            if (widget == null) continue;
            widget.active = true;
            widget.visible = true;
        }
        this.colorButtonHandler0.enableButtons();
    }

    private void disableMisc2Buttons() {
        for (Widget widget : this.misc2Buttons) {
            if (widget == null) continue;
            widget.active = false;
            widget.visible = false;
        }
        this.colorButtonHandler0.disableButtons();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String customTitle = this.title.func_150254_d();
        this.font.getClass();
        GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        this.drawString(this.font, customTitle, this.width / 2 - this.font.func_78256_a(customTitle) / 2, this.guiTop + 14, -7769547);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tab) {
            case GRAVE: {
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)this.graveModel));
                String graveName = stack.func_200301_q().func_150254_d();
                ItemBlockGrave.setModelTexture(stack, this.marbleType.ordinal());
                ItemBlockGrave.setEngravedName(stack, this.getMinecraft().field_71439_g.func_200200_C_().func_150254_d());
                String graveString = I18n.func_135052_a((String)graveName, (Object[])new Object[0]);
                this.drawString(this.font, graveString, this.width / 2 - this.font.func_78256_a(graveString) / 2, this.guiTop + this.ySize - 38, -7769547);
                GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + this.ySize - 42), (int)-15524569);
                GuiConfig.fill((int)(this.guiLeft + 10), (int)(this.guiTop + 40), (int)(this.guiLeft + this.xSize - 10), (int)(this.guiTop + this.ySize - 47), (int)-14340037);
                this.renderStackInGui(stack, this.guiLeft + 40, this.guiTop + 32, 5.0, true);
                break;
            }
            case PLATE: {
                this.getMinecraft().field_71446_o.func_110577_a(tablet);
                GuiConfig.blit((int)(this.guiLeft + 46), (int)(this.guiTop + 36), (float)0.0f, (float)0.0f, (int)120, (int)120, (int)120, (int)120);
                int adjustText = 24;
                String ripString = TextFormatting.BOLD + "R.I.P.";
                this.drawString(this.font, ripString, this.width / 2 - this.font.func_78256_a(ripString) / 2 + adjustText, this.guiTop + 60, this.colorButtonHandler1.getColor());
                String ownerString = TextFormatting.BOLD + this.getMinecraft().field_71439_g.func_200200_C_().func_150254_d();
                this.drawString(this.font, ownerString, this.width / 2 - this.font.func_78256_a(ownerString) / 2 + adjustText, this.guiTop + 90, this.colorButtonHandler2.getColor());
                String diedOnString = TextFormatting.ITALIC.toString() + "Hasn't died yet";
                this.drawString(this.font, diedOnString, this.width / 2 - this.font.func_78256_a(diedOnString) / 2 + adjustText, this.guiTop + 120, this.colorButtonHandler3.getColor());
                String soonString = TextFormatting.ITALIC.toString() + "but will soon";
                this.drawString(this.font, soonString, this.width / 2 - this.font.func_78256_a(soonString) / 2 + adjustText, this.guiTop + 130, this.colorButtonHandler3.getColor());
                break;
            }
            case MISC1: {
                break;
            }
            case MISC2: {
                GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 90), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 118), (int)0x55000000);
                this.drawString(this.font, "Particle Color", this.guiLeft + 10, this.guiTop + 100, this.colorButtonHandler0.getColor());
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderStackInGui(ItemStack stack, int xPosition, int yPosition, double scale, boolean isSpinning) {
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        this.getMinecraft().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.getMinecraft().field_71446_o.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scaled((double)scale, (double)scale, (double)scale);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IBakedModel bakedModel = this.itemRenderer.func_204206_b(stack);
        boolean isGui3d = bakedModel.func_177556_c();
        GlStateManager.translatef((float)((float)((double)xPosition / scale)), (float)((float)((double)yPosition / scale)), (float)(100.0f + this.itemRenderer.field_77023_b));
        GlStateManager.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.enableLighting();
        } else {
            GlStateManager.disableLighting();
        }
        ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        if (isSpinning) {
            GlStateManager.rotated((double)((double)System.currentTimeMillis() * 0.03 % 360.0), (double)0.0, (double)1.0, (double)0.0);
        }
        this.itemRenderer.func_180454_a(stack, bakedModel);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        double scaleRev = 1.0 / scale;
        GlStateManager.scaled((double)scaleRev, (double)scaleRev, (double)scaleRev);
        RenderHelper.func_74518_a();
        GlStateManager.popMatrix();
        this.getMinecraft().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.getMinecraft().field_71446_o.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
    }

    static enum TabConfig {
        GRAVE,
        PLATE,
        MISC1,
        MISC2;

    }
}

