/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class BlockGrave
extends BlockGraveBase<TileEntityGrave> {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    @Override
    protected Class<TileEntityGrave> getTileEntityClass() {
        return TileEntityGrave.class;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tile;
        super.func_176208_a(world, pos, state, player);
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityGrave) {
            IItemHandler inventory = ((TileEntityGrave)tile).getInventory();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.getStackInSlot(i).func_77946_l());
            }
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.func_201670_d()) {
            return this.activatePlayerGrave(world, pos, state, player);
        }
        return true;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean isToolEffective(BlockState state, ToolType type) {
        return false;
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        boolean valid;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityGrave tile = (TileEntityGrave)((Object)this.getTileEntity(world, pos));
        if (tile == null || tile.countTicks < 60 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory(player, new Location(pos, (IWorld)world));
        boolean bl = valid = hasKey || tile.isOwner(player) || !tile.getNeedAccess();
        if (valid) {
            tile.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.general.chanceMobOnGraveRecovery.get() > 0 && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> this.spawnRandomMob((ServerWorld)world, pos));
            }
        } else if (ModItems.grave_key.countKeyInInventory(player) > 0) {
            player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_WRONG_KEY.getTranslation());
        } else {
            player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.getTranslation());
        }
        return valid;
    }

    private void spawnRandomMob(ServerWorld world, BlockPos pos) {
        ZombieEntity mob;
        Location spawnPos = new SpawnHelper(world, new BlockPos(pos.func_177958_n() + Helper.getRandom(-9, 9), pos.func_177956_o(), pos.func_177952_p() + Helper.getRandom(-9, 9))).findSafePlace(2, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        try {
            mob = (ZombieEntity)EntityType.field_200725_aD.func_200721_a((World)world);
            if (mob == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        mob.func_82227_f(true);
        if (Helper.isDateAroundHalloween()) {
            mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Blocks.field_150423_aK));
        }
        mob.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos((Entity)mob)), SpawnReason.TRIGGERED, null, null);
        mob.func_70012_b((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)mob);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity.func_70093_af() && !entity.field_70128_L && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity)) {
            this.activatePlayerGrave(world, pos, state, (PlayerEntity)((ServerPlayerEntity)entity));
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    private static Block.Properties getBuilder() {
        return Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 1.8E7f).func_200951_a(6).func_200947_a(SoundType.field_185851_d);
    }
}

