/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.reflect.Reflection;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.mojang.brigadier.CommandDispatcher;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.capability.PerkRegistry;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.command.CommandTBKnownledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tombstone", "tombstone_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static final URL CONTRIBUTORS;
    public static final EnchantmentType TYPE_TOMBSTONE_ALL;

    public ModTombstone() {
        PerkRegistry.init();
        PacketHandler.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigTombstone.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigTombstone.GENERAL_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void preInit(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, Helper.getNullStorage(), TBSoulConsumerProvider::getDefault);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)WorldFunctionInjector.builder().put(new ResourceLocation(MOD_ID, "knowledge"), (sender, params) -> {
            Entity entity = sender.func_197022_f();
            if (entity instanceof ServerPlayerEntity) {
                EntityHelper.addKnowledge((ServerPlayerEntity)entity, params.getInt("amount", 1));
            }
        }).build());
        Reflection.initialize((Class[])new Class[]{ModTriggers.class});
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        if (SupportMods.GRAVESTONE.isLoaded()) {
            throw new RuntimeException("Corail Tombstone Exception : you loaded an incompatible grave mod : GraveStone");
        }
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        new CommandTBRestoreInventory((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBShowLastGrave((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleportGrave((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBKnownledge((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBRequestTeleport((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBSiege((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleportDiscovery((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBRecovery((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleport((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBReviveFamiliar((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        MinecraftForge.EVENT_BUS.register((Object)new CallbackHandler());
        Futures.addCallback(ContributorStore.read(CONTRIBUTORS, (Proxy)ObfuscationReflectionHelper.getPrivateValue(MinecraftServer.class, (Object)event.getServer(), (String)"field_110456_c")), (FutureCallback)new FutureCallback<ContributorStore>(){

            public void onSuccess(@Nullable ContributorStore result) {
                Helper.CONTRIBUTORS = result;
                LOGGER.info("The list of contributors and patreons has been loaded successfully");
            }

            public void onFailure(@Nonnull Throwable t) {
                LOGGER.info("The list of contributors and patreons couldn't be loaded");
                t.printStackTrace();
            }
        }, (Executor)event.getServer());
    }

    @SubscribeEvent
    public void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.clear();
        DeathHandler.INSTANCE.clear();
    }

    static {
        try {
            CONTRIBUTORS = new URL("https://raw.githubusercontent.com/Corail31/trash/master/contributors.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        TYPE_TOMBSTONE_ALL = Helper.addEnchantmentType("type_tombstone_all", p -> p != null && (p.func_77619_b() > 0 || p.func_77639_j() == 1), EnchantmentType.ALL);
    }
}

