/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.debugtools.DumpBlockNBT;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketDumpBlockInfo {
    private int dimid;
    private BlockPos pos;
    private boolean verbose;

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimid);
        NetworkTools.writePos(buf, this.pos);
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpBlockInfo(ByteBuf buf) {
        this.dimid = buf.readInt();
        this.pos = NetworkTools.readPos(buf);
        this.verbose = buf.readBoolean();
    }

    public PacketDumpBlockInfo(World world, BlockPos pos, boolean verbose) {
        this.dimid = world.func_201675_m().func_186058_p().func_186068_a();
        this.pos = pos;
        this.verbose = verbose;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int perm;
            ServerPlayerEntity player = ctx.getSender();
            MinecraftServer server = player.func_130014_f_().func_73046_m();
            OpList oppedPlayers = server.func_184103_al().func_152603_m();
            OpEntry entry = (OpEntry)oppedPlayers.func_152683_b((Object)player.func_146103_bH());
            int n = perm = entry == null ? server.func_110455_j() : entry.func_152644_a();
            if (perm >= 1) {
                ServerWorld world = DimensionManager.getWorld((MinecraftServer)server, (DimensionType)DimensionType.func_186069_a((int)this.dimid), (boolean)false, (boolean)false);
                String output = DumpBlockNBT.dumpBlockNBT((World)world, this.pos, this.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        });
        ctx.setPacketHandled(true);
    }
}

