/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDataFromServer {
    private BlockPos pos;
    private TypedMap result;
    private String command;

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            TypedMapTools.writeArguments(buf, this.result);
        }
    }

    public PacketDataFromServer(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        boolean resultPresent = buf.readBoolean();
        this.result = resultPresent ? TypedMapTools.readArguments(buf) : null;
    }

    public PacketDataFromServer(BlockPos pos, String command, TypedMap result) {
        this.pos = pos;
        this.command = command;
        this.result = result;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log("createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveDataFromServer(this.command, this.result)) {
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

