/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.RenderUtil;
import reborncore.common.util.FluidUtils;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.ITankHolder;

public class SCTank
extends FluidTank {
    private ITankHolder owner;
    private int tankid;
    private boolean isLocked;

    public SCTank(ITankHolder owner, int tankSize, int tankid) {
        super(tankSize);
        this.owner = owner;
        this.tankid = tankid;
    }

    public SCTank copy() {
        SCTank tank = new SCTank(this.owner, this.capacity, this.tankid);
        if (this.getFluid() != null) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public void containerTransfer() {
        IFluidHandlerItem handler;
        ItemStack item = this.owner.getInputContainer(this.tankid);
        if (!(item.func_190926_b() || (handler = FluidUtils.getFluidHandler((ItemStack)item)) == null || this.fluid != null && this.capacity - this.fluid.amount < 1000)) {
            FluidStack fluidStack = handler.drain(1000, false);
            if (fluidStack != null && fluidStack.amount >= 1000) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)item, (IFluidHandler)this, (int)1000, null, (boolean)false);
                if (result.isSuccess()) {
                    ItemStack container = result.getResult();
                    handler = FluidUtils.getFluidHandler((ItemStack)container);
                    if (handler != null && (fluidStack = handler.drain(1000, false)) != null && fluidStack.amount == 1000) {
                        FluidUtil.tryEmptyContainer((ItemStack)item, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        this.owner.setInputContainer(this.tankid, container);
                        return;
                    }
                    if (!container.func_190926_b()) {
                        this.owner.addToOutputContainer(this.tankid, container);
                    }
                    if (container.func_190916_E() == 0) {
                        FluidUtil.tryEmptyContainer((ItemStack)item, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        item.func_190918_g(1);
                        if (item.func_190926_b() || item.func_190916_E() <= 0) {
                            this.owner.setInputContainer(this.tankid, ItemStack.field_190927_a);
                        }
                    }
                }
            } else {
                ItemStack container;
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)item, (IFluidHandler)this, (int)1000, null, (boolean)false);
                if (result.isSuccess() && !(container = result.getResult()).func_190926_b()) {
                    this.owner.addToOutputContainer(this.tankid, container);
                    if (container.func_190916_E() == 0) {
                        FluidUtil.tryFillContainer((ItemStack)item, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        item.func_190918_g(1);
                        if (item.func_190926_b() || item.func_190916_E() <= 0) {
                            this.owner.setInputContainer(this.tankid, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0 && !this.isLocked) {
                this.fluid = null;
            }
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained));
            }
        }
        return stack;
    }

    public void setLocked(boolean val) {
        this.isLocked = val;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (this.fluid != null) {
            name = this.fluid.getFluid().getLocalizedName(this.fluid);
            if (name.indexOf(".") != -1) {
                name = FluidRegistry.getFluidName((FluidStack)this.fluid);
            }
            name = name != null && !name.equals("") ? this.fluid.getFluid().getRarity().field_77937_e.toString() + Character.toUpperCase(name.charAt(0)) + name.substring(1) + TextFormatting.WHITE : Localization.MODULES.TANKS.INVALID.translate(new String[0]);
            amount = this.fluid.amount;
        }
        NumberFormat format = NumberFormat.getInstance();
        return name + "\n" + format.format(amount) + " / " + format.format(this.capacity);
    }

    protected void onContentsChanged() {
        this.owner.onFluidUpdated(this.tankid);
    }

    private static float getColorComponent(int color, int id) {
        return (float)((color & 255 << id * 8) >> id * 8) / 255.0f;
    }

    public static void applyColorFilter(FluidStack fluid) {
        int color = fluid.getFluid().getColor(fluid);
        GlStateManager.func_179131_c((float)SCTank.getColorComponent(color, 2), (float)SCTank.getColorComponent(color, 1), (float)SCTank.getColorComponent(color, 0), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFluid(GuiBase gui, int startX, int startY) {
        if (this.fluid != null) {
            int fluidLevel = (int)(48.0f * ((float)this.fluid.amount / (float)this.capacity));
            TextureAtlasSprite icon = RenderUtil.getStillTexture((FluidStack)this.fluid);
            if (icon == null) {
                return;
            }
            RenderUtil.bindBlockTexture();
            SCTank.applyColorFilter(this.fluid);
            GlStateManager.func_179147_l();
            for (int y = 0; y < 3; ++y) {
                int pixels = fluidLevel - (2 - y) * 16;
                if (pixels <= 0) continue;
                if (pixels > 16) {
                    pixels = 16;
                }
                for (int x = 0; x < 2; ++x) {
                    this.owner.drawImage(this.tankid, gui, icon, startX + 2 + 16 * x, startY + 1 + 16 * y + (16 - pixels), 0, 16 - pixels, 16, pixels);
                }
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.fluid, this.getCapacity());
    }
}

