/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.tile;

import com.teamwizardry.librarianlib.features.autoregister.TileRegister;
import com.teamwizardry.librarianlib.features.base.block.tile.TileModTickable;
import com.teamwizardry.librarianlib.features.base.block.tile.module.ModuleInventory;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.saving.Module;
import com.teamwizardry.librarianlib.features.tesr.TileRenderer;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRegistry;
import com.teamwizardry.wizardry.client.render.block.TileHaloInfuserRenderer;
import com.teamwizardry.wizardry.common.entity.EntityHaloInfusionItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

@TileRegister(value="wizardry:halo_infuser")
@TileRenderer(value=TileHaloInfuserRenderer.class)
public class TileHaloInfuser
extends TileModTickable {
    @Module
    private ModuleInventory haloInv = new ModuleInventory(1);
    private ArrayList<EntityHaloInfusionItem> entities = new ArrayList();

    public void onLoad() {
        super.onLoad();
        this.refreshEntities();
    }

    public void tick() {
        if (this.entities.size() != HaloInfusionItemRegistry.getItems().size()) {
            this.refreshEntities();
            this.updateItems(true);
        }
        if (this.field_145850_b.field_72995_K) {
            for (EntityHaloInfusionItem entity : this.entities) {
                entity.getHaloInfusionItem().render(entity.field_70170_p, entity.func_174791_d().func_72441_c(0.0, (double)entity.field_70131_O / 2.0, 0.0));
            }
        }
    }

    public ItemStack getHalo() {
        return ((ItemStackHandler)this.haloInv.getHandler()).getStackInSlot(0);
    }

    public void setHalo(ItemStack stack) {
        ((ItemStackHandler)this.haloInv.getHandler()).setStackInSlot(0, stack);
        this.updateItems(true);
    }

    public void refreshEntities() {
        this.entities.forEach(entityHaloInfusionItem -> this.field_145850_b.func_72900_e((Entity)entityHaloInfusionItem));
        this.entities.clear();
        int count = HaloInfusionItemRegistry.getItems().size();
        double radius = 3.0;
        for (int i = 0; i < count; ++i) {
            float angle = (float)((double)i * Math.PI * 2.0 / (double)count);
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)MathHelper.func_76134_b((float)angle) * radius;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)MathHelper.func_76126_a((float)angle) * radius;
            EntityHaloInfusionItem entity = new EntityHaloInfusionItem(this.field_145850_b, HaloInfusionItemRegistry.EMPTY, this.func_174877_v(), i);
            entity.func_70107_b(x, this.field_174879_c.func_177956_o() + 2, z);
            entity.field_98038_p = true;
            this.field_145850_b.func_72838_d((Entity)entity);
            this.entities.add(entity);
        }
    }

    public void updateItems(boolean soft) {
        int i;
        NBTTagList slots = ItemNBTHelper.getList((ItemStack)this.getHalo(), (String)"slots", NBTTagString.class);
        if (slots == null || slots.func_74745_c() < HaloInfusionItemRegistry.getItems().size() - 1) {
            slots = new NBTTagList();
            for (i = 0; i < HaloInfusionItemRegistry.getItems().size(); ++i) {
                slots.func_74742_a((NBTBase)new NBTTagString(HaloInfusionItemRegistry.EMPTY.getNbtName()));
            }
            ItemNBTHelper.setList((ItemStack)this.getHalo(), (String)"slots", (NBTTagList)slots);
        }
        for (i = 0; i < HaloInfusionItemRegistry.getItems().size(); ++i) {
            EntityHaloInfusionItem entity = this.entities.get(i);
            String itemName = slots.func_150307_f(i);
            entity.setHaloInfusionItem(HaloInfusionItemRegistry.getItemFromName(itemName), soft);
        }
    }

    public ItemStack extractHalo() {
        return ((ItemStackHandler)this.haloInv.getHandler()).extractItem(0, 1, false);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 4096.0;
    }
}

