/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.spell.IContinuousModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextSuper;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideSuper;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_beam")
@Mod.EventBusSubscriber(modid="wizardry")
public class ModuleShapeBeam
implements IModuleShape,
IContinuousModule {
    public static final String BEAM_OFFSET = "beam offset";
    public static final String BEAM_CAST = "beam cast";
    public static final HashMap<ItemStack, BeamTicker> beamTickMap = new HashMap();

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range", "modifier_increase_potency"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ItemStack stack = event.player.func_184614_ca();
        beamTickMap.keySet().removeIf(itemStack -> !ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)stack));
    }

    @Override
    public boolean run(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = spell.getOrigin();
        Entity caster = spell.getCaster();
        if (look == null || position == null || caster == null) {
            return false;
        }
        ItemStack stack = ((EntityLivingBase)caster).func_184614_ca();
        if (stack.func_190926_b()) {
            return true;
        }
        beamTickMap.putIfAbsent(stack, new BeamTicker());
        BeamTicker ticker = beamTickMap.get(stack);
        double range = spellRing.getAttributeValue(AttributeRegistry.RANGE, spell);
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell);
        double beamOffset = ticker.ticks + potency;
        ticker.cast = false;
        if (beamOffset >= (double)ConfigValues.beamTimer) {
            beamOffset %= (double)ConfigValues.beamTimer;
            if (!spellRing.taxCaster(spell, true)) {
                ticker.ticks = beamOffset;
                return false;
            }
            IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
            overrides.onRunBeam(spell, spellRing);
            RayTraceResult trace = new RayTrace(world, look, position, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
            spell.processTrace(trace, look.func_186678_a(range));
            if (spellRing.getChildRing() != null) {
                spellRing.getChildRing().runSpellRing(spell);
            }
            ticker.cast = true;
            instance.sendRenderPacket(spell, spellRing);
        }
        ticker.ticks = beamOffset;
        return true;
    }

    private NBTTagList serializeBeamTicks() {
        NBTTagList list = new NBTTagList();
        beamTickMap.forEach((stack, beamTicker) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("stack", (NBTBase)stack.serializeNBT());
            compound.func_74780_a("tick", beamTicker.ticks);
            compound.func_74757_a("cast", beamTicker.cast);
            list.func_74742_a((NBTBase)compound);
        });
        return list;
    }

    private void deserializeBeamTicks(NBTTagList list) {
        for (NBTBase base : list) {
            NBTTagCompound compound;
            if (!(base instanceof NBTTagCompound) || !(compound = (NBTTagCompound)base).func_74764_b("stack") || !compound.func_74764_b("tick") || !compound.func_74764_b("cast")) continue;
            ItemStack itemStack = new ItemStack((NBTTagCompound)compound.func_74781_a("stack"));
            BeamTicker ticker = new BeamTicker();
            ticker.ticks = compound.func_74769_h("tick");
            ticker.cast = compound.func_74767_n("cast");
            beamTickMap.put(itemStack, ticker);
        }
    }

    @Override
    @NotNull
    public SpellData renderVisualization(ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, @Nonnull SpellData previousData) {
        World world = data.world;
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = data.getOrigin();
        Entity caster = data.getCaster();
        if (look == null || position == null || caster == null) {
            return previousData;
        }
        double range = ring.getAttributeValue(AttributeRegistry.RANGE, data);
        RayTraceResult trace = new RayTrace(world, look, position, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(trace, look.func_186678_a(range));
        return previousData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderBeam(spell, spellRing)) {
            return;
        }
        World world = spell.world;
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = spell.getOrigin();
        Entity caster = spell.getCaster();
        if (look == null || position == null || caster == null) {
            return;
        }
        ItemStack stack = ((EntityLivingBase)caster).func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        double range = spellRing.getAttributeValue(AttributeRegistry.RANGE, spell);
        RayTraceResult trace = new RayTrace(world, look, position, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        Vec3d target = trace.field_72307_f;
        if (target == null) {
            return;
        }
        LibParticles.SHAPE_BEAM(world, target, spell.getOriginHand(), RandUtil.nextBoolean() ? spellRing.getPrimaryColor() : spellRing.getSecondaryColor());
    }

    @ModuleOverride(value="shape_beam_render")
    public boolean onRenderBeam(SpellData data, SpellRing shape) {
        return false;
    }

    @ModuleOverride(value="shape_beam_run")
    public void onRunBeam(@ContextSuper ModuleOverrideSuper ovdSuper, SpellData data, SpellRing shape) {
    }

    public static class BeamTicker {
        boolean cast = false;
        double ticks = 0.0;

        BeamTicker() {
        }
    }
}

