/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.IContinuousModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_telekinesis")
public class ModuleEffectTelekinesis
implements IModuleEffect,
IContinuousModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d targetPos = spell.getTarget();
        Entity caster = spell.getCaster();
        double potency = spellRing.getAttributeValue(AttributeRegistry.AREA, spell);
        if (targetPos == null) {
            return false;
        }
        List entityList = world.func_72839_b(caster, new AxisAlignedBB(new BlockPos(targetPos)).func_72314_b(potency, potency, potency));
        if (RandUtil.nextInt(10) == 0) {
            spell.world.func_184133_a(null, new BlockPos(targetPos), (SoundEvent)ModSounds.ETHEREAL_PASS_BY, SoundCategory.NEUTRAL, 0.5f, RandUtil.nextFloat());
        }
        for (Entity entity : entityList) {
            double dist = entity.func_174791_d().func_72438_d(targetPos);
            if (dist > potency) continue;
            if (!spellRing.taxCaster(spell, true)) {
                return false;
            }
            double upperMag = 1.0;
            double scale = 1.0;
            double mag = 1.0 * (1.0 * dist / (-1.0 * dist - 1.0) + 1.0);
            Vec3d dir = targetPos.func_178788_d(entity.func_174791_d()).func_72432_b().func_186678_a(mag);
            entity.field_70159_w = dir.field_72450_a;
            entity.field_70181_x = dir.field_72448_b;
            entity.field_70179_y = dir.field_72449_c;
            entity.field_70143_R = 0.0f;
            entity.field_70133_I = true;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.setScale(1.0f);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)5, (int)0, (aFloat, particleBuilder) -> {
            glitter.setLifetime(RandUtil.nextInt(10, 20));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, RandUtil.nextFloat()));
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
        });
    }
}

