/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_decay")
public class ModuleEffectDecay
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim();
        BlockPos targetPos = spell.getTargetPos();
        if (targetPos == null) {
            return false;
        }
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 5.0;
        double time = spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 10.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        spell.world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.SLOW_MOTION_IN, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat(0.1f, 0.5f));
        if (targetEntity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)targetEntity;
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)time, (int)potency));
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)time, (int)potency));
        }
        if (targetPos != null) {
            // empty if block
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)500, (int)0, (i, build) -> {
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.1f, 1.0f), 1.0f));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z).func_72432_b().func_186678_a(1.5 * (double)RandUtil.nextFloat()));
            build.setAcceleration(Vec3d.field_186680_a);
            build.setLifetime(50);
            build.setDeceleration(new Vec3d(0.7, 0.7, 0.7));
            build.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
            build.setTick(particle -> {
                if (particle.getAge() > 15) {
                    particle.setAcceleration(new Vec3d(0.0, -0.015, 0.0));
                    particle.setJitterChance(1.0f);
                    particle.setJitterMagnitude(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), 0.0, RandUtil.nextDouble(-0.05, 0.05)));
                }
            });
        });
    }
}

