/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.entity.EntityBackupZombie;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_backup")
public class ModuleEffectBackup
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d targetPos = spell.getTarget();
        EnumFacing facing = spell.getData(SpellData.DefaultKeys.FACE_HIT);
        Entity caster = spell.getCaster();
        double duration = spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 20.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetPos == null) {
            return true;
        }
        if (!(caster instanceof EntityLivingBase)) {
            return true;
        }
        if (facing != null && !world.func_175623_d(new BlockPos(targetPos))) {
            targetPos = new Vec3d((Vec3i)new BlockPos(targetPos).func_177972_a(facing)).func_72441_c(0.5, 0.5, 0.5);
        }
        EntityBackupZombie zombie = new EntityBackupZombie(world, (EntityLivingBase)caster, (int)duration);
        zombie.func_70107_b(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c);
        zombie.field_98038_p = true;
        world.func_72838_d((Entity)zombie);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.enableMotionCalculation();
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setAcceleration(new Vec3d(0.0, -0.05, 0.0));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)RandUtil.nextInt(20, 30), (int)0, (aFloat, particleBuilder) -> {
            if (RandUtil.nextInt(5) == 0) {
                glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            } else {
                glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            }
            glitter.setScale(RandUtil.nextFloat());
            glitter.setLifetime(RandUtil.nextInt(50, 100));
            glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.01, 0.05), RandUtil.nextDouble(-0.05, 0.05)));
        });
    }
}

