/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block.fluid;

import com.teamwizardry.librarianlib.features.base.fluid.BlockModFluid;
import com.teamwizardry.librarianlib.features.base.fluid.ModFluid;
import com.teamwizardry.librarianlib.features.forgeevents.EntityUpdateEvent;
import com.teamwizardry.wizardry.api.block.FluidTracker;
import com.teamwizardry.wizardry.api.item.IExplodable;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.block.fluid.MaterialMana;
import com.teamwizardry.wizardry.common.block.fluid.ModFluids;
import com.teamwizardry.wizardry.common.core.DamageSourceMana;
import com.teamwizardry.wizardry.crafting.mana.FluidRecipeLoader;
import com.teamwizardry.wizardry.crafting.mana.ManaRecipes;
import com.teamwizardry.wizardry.init.ModPotions;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockFluidMana
extends BlockModFluid {
    public BlockFluidMana(ModFluid mana) {
        super((Fluid)mana, (Material)new MaterialMana(MapColor.field_151662_n));
        this.setQuantaPerBlock(6);
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.field_72995_K) {
            LibParticles.FIZZING_AMBIENT(world, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return true;
    }

    @SubscribeEvent
    public static void onEntityUpdate(EntityUpdateEvent event) {
        Entity entityIn;
        World world = entityIn.field_70170_p;
        entityIn = event.getEntity();
        BlockPos pos = entityIn.func_180425_c();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModFluids.MANA.getActualBlock()) {
            if (world.field_72995_K) {
                BlockFluidMana.run(world, pos, state.func_177230_c(), entityIn, entity -> true, entity -> LibParticles.FIZZING_AMBIENT(world, entityIn.func_174791_d()));
            }
            if (!world.field_72995_K) {
                BlockFluidMana.run(world, pos, state.func_177230_c(), entityIn, entity -> entity instanceof EntityLivingBase, entity -> {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 100, 0, true, false));
                    if (RandUtil.nextInt(50) == 0) {
                        entity.func_70097_a((DamageSource)DamageSourceMana.INSTANCE, 0.1f);
                    }
                });
            }
            BlockFluidMana.run(world, pos, state.func_177230_c(), entityIn, entity -> entity instanceof EntityPlayer, entity -> {
                if (!world.field_72995_K) {
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    Advancement advancement = server.func_191949_aK().func_192778_a(new ResourceLocation("wizardry", "advancements/advancement_crunch.json"));
                    if (advancement == null) {
                        return;
                    }
                    AdvancementProgress progress = ((EntityPlayerMP)entity).func_192039_O().func_192747_a(advancement);
                    for (String s : progress.func_192107_d()) {
                        ((EntityPlayerMP)entity).func_192039_O().func_192750_a(advancement, s);
                    }
                }
                if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d && RandUtil.nextInt(50) == 0) {
                    ((EntityPlayer)entity).func_71024_bL().func_75113_a(1.0f);
                }
            });
            BlockFluidMana.run(world, pos, state.func_177230_c(), entityIn, entity -> entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() instanceof IExplodable, entity -> FluidTracker.INSTANCE.addManaCraft(entity.field_70170_p, entity.func_180425_c(), new ManaRecipes.ExplodableCrafter()));
        }
        BlockFluidMana.run(world, pos, state.func_177230_c(), entityIn, entity -> entity instanceof EntityItem && ManaRecipes.RECIPES.keySet().stream().anyMatch(item -> item.apply(((EntityItem)entity).func_92059_d())), entity -> {
            List<Map.Entry> allEntries = ManaRecipes.RECIPES.entries().stream().filter(entry -> ((FluidRecipeLoader.FluidCrafter)entry.getValue()).getFluid().getBlock() == state.func_177230_c() && ((Ingredient)entry.getKey()).apply(((EntityItem)entity).func_92059_d())).collect(Collectors.toList());
            allEntries.forEach(crafter -> FluidTracker.INSTANCE.addManaCraft(entity.field_70170_p, entity.func_180425_c(), ((FluidRecipeLoader.FluidCrafter)crafter.getValue()).build()));
        });
    }

    public static void run(World world, BlockPos pos, Block block, Entity entity, Predicate<Entity> test, Consumer<Entity> process) {
        if (!(block instanceof IFluidBlock)) {
            return;
        }
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        float height = up.func_185904_a().func_76224_d() || up.func_177230_c() instanceof IFluidBlock ? 1.0f : ((IFluidBlock)block).getFilledPercentage(world, pos) * 0.875f;
        AxisAlignedBB bb = new AxisAlignedBB(pos).func_191195_a(0.0, (double)(1.0f - height), 0.0);
        AxisAlignedBB entityBox = entity.func_70046_E();
        if ((entityBox == null || entityBox.func_72326_a(bb)) && test.test(entity)) {
            process.accept(entity);
        }
    }
}

