/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block;

import com.teamwizardry.librarianlib.features.base.block.tile.BlockModContainer;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.wizardry.client.render.block.TileJarRenderer;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.common.item.ItemJar;
import com.teamwizardry.wizardry.common.tile.TileJar;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockJar
extends BlockModContainer {
    private static final AxisAlignedBB AABB_JAR = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);

    public BlockJar() {
        super("jar_block", Material.field_151592_s, new String[0]);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_149752_b(1.5f);
        this.func_149713_g(0);
    }

    @Nullable
    public ItemBlock createItemForm() {
        return new ItemJar((Block)this);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity != null && entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            return jar.hasFairy ? 15 : 0;
        }
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity entity;
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"fairy_inside", (boolean)false) && (entity = worldIn.func_175625_s(pos)) != null && entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            jar.color = new Color(ItemNBTHelper.getInt((ItemStack)stack, (String)"fairy_color", (int)0xFFFFFF));
            jar.age = ItemNBTHelper.getInt((ItemStack)stack, (String)"fairy_age", (int)0);
            jar.hasFairy = true;
            jar.func_70296_d();
            worldIn.func_175664_x(pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)this);
        TileEntity entity = world.func_175625_s(pos);
        if (entity != null && entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            if (jar.color == null) {
                return stack;
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)"fairy_color", (int)jar.color.getRGB());
            ItemNBTHelper.setInt((ItemStack)stack, (String)"fairy_age", (int)jar.age);
        }
        return stack;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof TileJar) {
            TileJar jar = (TileJar)tile;
            if (playerIn.func_70093_af() && jar.hasFairy) {
                EntityFairy entity = new EntityFairy(worldIn, jar.color, jar.age);
                entity.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
                worldIn.func_72838_d((Entity)entity);
                jar.hasFairy = false;
                jar.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_JAR;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState iBlockState) {
        return new TileJar();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileJar.class, (TileEntitySpecialRenderer)new TileJarRenderer());
    }
}

