/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.block;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.base.block.tile.TileMod;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.tesr.TileRenderHandler;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.block.IStructure;
import com.teamwizardry.wizardry.api.block.WizardryStructureRenderCompanion;
import com.teamwizardry.wizardry.api.capability.mana.CapManager;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.core.renderer.StructureErrorRenderer;
import com.teamwizardry.wizardry.common.tile.TileManaBattery;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModStructures;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="wizardry")
public class TileManaBatteryRenderer
extends TileRenderHandler<TileManaBattery> {
    private static IBakedModel modelRing;
    private static IBakedModel modelCrystal;
    private static IBakedModel modelRingOuter;
    private WizardryStructureRenderCompanion wizardryStructure;

    public TileManaBatteryRenderer(@Nonnull TileManaBattery manaBattery) {
        super((TileMod)manaBattery);
        this.wizardryStructure = ModStructures.INSTANCE.getStructure(((TileManaBattery)this.tile).func_145838_q());
    }

    private static boolean getBakedModels() {
        IModel model;
        if (modelRing == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("wizardry", "block/mana_crystal_ring"));
                modelRing = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelRingOuter == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("wizardry", "block/mana_crystal_ring_outer"));
                modelRingOuter = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modelCrystal == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("wizardry", "block/mana_crystal"));
                modelCrystal = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return modelRing != null && modelRingOuter != null && modelCrystal != null;
    }

    public void render(float partialTicks, int destroyStage, float alpha) {
        if (!TileManaBatteryRenderer.getBakedModels()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        TextureManager texturemanager = Minecraft.func_71410_x().field_71446_o;
        if (texturemanager != null) {
            texturemanager.func_110577_a(TextureMap.field_110575_b);
        }
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        float fill = (float)(CapManager.getMana(((TileManaBattery)this.tile).getWizardryCap()) / CapManager.getMaxMana(((TileManaBattery)this.tile).getWizardryCap())) / 50.0f;
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179101_C();
        double x = RandUtil.nextDouble(-fill, fill);
        double y = RandUtil.nextDouble(-fill, fill);
        double z = RandUtil.nextDouble(-fill, fill);
        GlStateManager.func_179137_b((double)0.0, (double)(Math.sin(((float)((TileManaBattery)this.tile).func_145831_w().func_82737_E() + ClientTickHandler.getPartialTicks()) / 40.0f) / 8.0), (double)0.0);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(modelCrystal, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179114_b((float)((float)((TileManaBattery)this.tile).func_145831_w().func_82737_E() + ClientTickHandler.getPartialTicks()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(modelRing, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179114_b((float)((float)((TileManaBattery)this.tile).func_145831_w().func_82737_E() + ClientTickHandler.getPartialTicks()), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)((TileManaBattery)this.tile).func_145831_w().func_82737_E() + ClientTickHandler.getPartialTicks()), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(modelRingOuter, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ArrayList<BlockPos> errors = new ArrayList<BlockPos>(((IStructure)((TileManaBattery)this.tile).func_145838_q()).testStructure(((TileManaBattery)this.tile).func_145831_w(), ((TileManaBattery)this.tile).func_174877_v()));
        errors.sort(Vec3i::compareTo);
        if (((TileManaBattery)this.tile).revealStructure && ((TileManaBattery)this.tile).func_145838_q() instanceof IStructure && !errors.isEmpty()) {
            this.wizardryStructure.draw((IBlockAccess)((TileManaBattery)this.tile).func_145831_w(), (float)(Math.sin((double)((TileManaBattery)this.tile).func_145831_w().func_82737_E() / 10.0) + 1.0) / 10.0f + 0.4f);
            return;
        }
        if (!((TileManaBattery)this.tile).revealStructure && !errors.isEmpty()) {
            for (BlockPos error : errors) {
                StructureErrorRenderer.addError(error);
            }
        }
        if (((TileManaBattery)this.tile).func_145838_q() == ModBlocks.CREATIVE_MANA_BATTERY) {
            double angle = (double)((TileManaBattery)this.tile).func_145831_w().func_82737_E() / 10.0;
            double x1 = Math.cos((float)angle);
            double y1 = Math.sin((float)angle);
            ParticleBuilder builder = new ParticleBuilder(10);
            builder.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            builder.setCollision(true);
            builder.disableRandom();
            builder.disableMotionCalculation();
            ParticleSpawner.spawn((ParticleBuilder)builder, (World)((TileManaBattery)this.tile).func_145831_w(), (InterpFunction)new InterpCircle(new Vec3d((Vec3i)((TileManaBattery)this.tile).func_174877_v()).func_72441_c(0.5, 0.5, 0.5), new Vec3d(x1, x1, y1), 1.5f), (int)20, (int)0, (aFloat, particleBuilder) -> {
                particleBuilder.setScale(0.5f);
                particleBuilder.setColor(new Color(14024914));
                particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
                particleBuilder.setLifetime(RandUtil.nextInt(5, 10));
            });
        }
    }

    static {
        ClientRunnable.registerReloadHandler(() -> {
            modelRing = null;
            modelCrystal = null;
            modelRingOuter = null;
        });
    }
}

