/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static float signAngle(Vec3d a, Vec3d b, Vec3d n) {
        Vec3d cross = a.func_72431_c(b);
        double s = cross.func_72433_c();
        double c = a.func_72430_b(b);
        double angle = MathHelper.func_181159_b((double)s, (double)c);
        if (n != null && n.func_72430_b(cross) < 0.0) {
            angle = -angle;
        }
        return (float)Math.toDegrees(angle);
    }

    public static boolean isLyingInCone(Vec3d point, Vec3d coneApex, Vec3d baseCenter, float aperture) {
        float[] x = new float[]{(float)point.field_72450_a, (float)point.field_72448_b, (float)point.field_72449_c};
        float[] t = new float[]{(float)coneApex.field_72450_a, (float)coneApex.field_72448_b, (float)coneApex.field_72449_c};
        float[] b = new float[]{(float)baseCenter.field_72450_a, (float)baseCenter.field_72448_b, (float)baseCenter.field_72449_c};
        return Utils.isLyingInCone(x, t, b, aperture);
    }

    private static boolean isLyingInCone(float[] x, float[] t, float[] b, float aperture) {
        float[] axisVect;
        boolean isInInfiniteCone;
        float halfAperture = aperture / 2.0f;
        float[] apexToXVect = Utils.dif(t, x);
        boolean bl = isInInfiniteCone = (double)(Utils.dotProd(apexToXVect, axisVect = Utils.dif(t, b)) / Utils.magn(apexToXVect) / Utils.magn(axisVect)) > Math.cos(halfAperture);
        if (!isInInfiniteCone) {
            return false;
        }
        return Utils.dotProd(apexToXVect, axisVect) / Utils.magn(axisVect) < Utils.magn(axisVect);
    }

    private static float dotProd(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private static float[] dif(float[] a, float[] b) {
        return new float[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
    }

    private static float magn(float[] a) {
        return (float)Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    public static int compareVersions(String ver1, String ver2) {
        int res;
        if (ver1 == null || ver2 == null) {
            return 0;
        }
        String v1 = ver1.replaceAll("[^0-9]+", "");
        String v2 = ver2.replaceAll("[^0-9]+", "");
        int len1 = v1.length();
        int len2 = v2.length();
        if (len1 > 0 && len2 > 0) {
            v1 = v1.charAt(len1 - 1) == '0' ? v1.substring(0, len1 - 1) : v1;
            String string = v2 = v2.charAt(len2 - 1) == '0' ? v2.substring(0, len2 - 1) : v2;
        }
        return (res = v1.compareTo(v2)) < 0 ? -1 : (res > 0 ? 1 : res);
    }

    public static boolean hasOreDictPrefix(ItemStack stack, String dict) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (OreDictionary.getOreName((int)id).length() < dict.length() || OreDictionary.getOreName((int)id).substring(0, dict.length()).compareTo(dict) != 0) continue;
            return true;
        }
        return false;
    }

    public static List<GuiComponent> getVisibleComponents(List<GuiComponent> objects, double scroll) {
        int ROWS = 3;
        int COLS = 5;
        int SPACES = 15;
        if (objects.size() <= 15) {
            return objects;
        }
        int rows = MathHelper.func_76143_f((double)((double)(objects.size() - 15) / 5.0));
        double rowsScrolled = scroll * (double)rows;
        int startIndex = (int)rowsScrolled * 5;
        int endIndex = startIndex + 15;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > objects.size()) {
            endIndex = objects.size();
        }
        ArrayList<GuiComponent> visible = new ArrayList<GuiComponent>();
        visible.addAll(objects.subList(startIndex, endIndex));
        return visible;
    }

    public static int getSlotFor(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !Utils.stackEqualExact(stack, (ItemStack)player.field_71071_by.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

