/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import net.minecraft.nbt.NBTTagCompound;

public class FixedPointUtils {
    public static final double NBT_FIXEDPOINT_GRANULARITY = 2048.0;

    private FixedPointUtils() {
    }

    public static double fixedToDouble(long fixedVal) {
        return (double)fixedVal / 2048.0;
    }

    public static long doubleToFixed(double dblVal) {
        return (long)(dblVal * 2048.0);
    }

    public static double getDoubleFromNBT(NBTTagCompound nbt, String key) {
        byte dataType = nbt.func_150299_b(key);
        if (dataType == 5 || dataType == 6) {
            return nbt.func_74769_h(key);
        }
        if (dataType == 1 || dataType == 2 || dataType == 3 || dataType == 4) {
            return FixedPointUtils.fixedToDouble(nbt.func_74763_f(key));
        }
        return 0.0;
    }

    public static long getFixedFromNBT(NBTTagCompound nbt, String key) {
        byte dataType = nbt.func_150299_b(key);
        if (dataType == 5 || dataType == 6) {
            return FixedPointUtils.doubleToFixed(nbt.func_74769_h(key));
        }
        if (dataType == 1 || dataType == 2 || dataType == 3 || dataType == 4) {
            return nbt.func_74763_f(key);
        }
        return 0L;
    }

    public static void setDoubleToNBT(NBTTagCompound nbt, String key, double value) {
        nbt.func_74772_a(key, FixedPointUtils.doubleToFixed(value));
    }

    public static void setFixedToNBT(NBTTagCompound nbt, String key, long value) {
        nbt.func_74772_a(key, value);
    }
}

