/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.teamwizardry.wizardry.api.util.RandUtil;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;

public class ColorUtils {
    public static Color mixColors(List<Color> colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (Color color : colors) {
            double colorCount = 0.0;
            if (color.getRed() > 0) {
                colorCount += 1.0;
            }
            if (color.getGreen() > 0) {
                colorCount += 1.0;
            }
            if (color.getBlue() > 0) {
                colorCount += 1.0;
            }
            if (colorCount <= 0.0) continue;
            red = (int)((double)red + (double)((float)(color.getRed() * color.getAlpha()) / 255.0f) / colorCount);
            green = (int)((double)green + (double)((float)(color.getGreen() * color.getAlpha()) / 255.0f) / colorCount);
            blue = (int)((double)blue + (double)((float)(color.getBlue() * color.getAlpha()) / 255.0f) / colorCount);
        }
        if (!colors.isEmpty()) {
            red = Math.min(red / colors.size(), 255);
            green = Math.min(green / colors.size(), 255);
            blue = Math.min(blue / colors.size(), 255);
        }
        return new Color(red, green, blue);
    }

    public static Color mixColors(@Nonnull Color color1, @Nonnull Color color2) {
        float r = ((float)color1.getRed() / 255.0f + (float)color2.getRed() / 255.0f) / 2.0f;
        float g = ((float)color1.getGreen() / 255.0f + (float)color2.getGreen() / 255.0f) / 2.0f;
        float b = ((float)color1.getBlue() / 255.0f + (float)color2.getBlue() / 255.0f) / 2.0f;
        float a = ((float)color1.getAlpha() / 255.0f + (float)color2.getAlpha() / 255.0f) / 2.0f;
        if (Math.round(r * 255.0f) == color2.getRed()) {
            r = (float)color2.getRed() / 255.0f;
        }
        if (Math.round(g * 255.0f) == color2.getGreen()) {
            g = (float)color2.getGreen() / 255.0f;
        }
        if (Math.round(b * 255.0f) == color2.getBlue()) {
            b = (float)color2.getBlue() / 255.0f;
        }
        if (Math.round(a * 255.0f) == color2.getAlpha()) {
            a = (float)color2.getAlpha() / 255.0f;
        }
        return new Color(r, g, b, a);
    }

    public static Color changeColorAlpha(@Nonnull Color color, int newAlpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    public static Color shiftColorHueRandomly(@Nonnull Color color, double shiftAmount) {
        return new Color((int)Math.max(0.0, Math.min((double)color.getRed() + RandUtil.nextDouble(-shiftAmount, shiftAmount), 255.0)), (int)Math.max(0.0, Math.min((double)color.getGreen() + RandUtil.nextDouble(-shiftAmount, shiftAmount), 255.0)), (int)Math.max(0.0, Math.min((double)color.getBlue() + RandUtil.nextDouble(-shiftAmount, shiftAmount), 255.0)));
    }

    public static float[] getHSVFromColor(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static Color getColorFromHSV(float[] hsv) {
        return new Color(Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
    }
}

