/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.utilities.AnnotationHelper;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterOverrideDefaults;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRange;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.Operation;
import com.teamwizardry.wizardry.api.spell.module.IModule;
import com.teamwizardry.wizardry.api.spell.module.ModuleFactory;
import com.teamwizardry.wizardry.api.spell.module.ModuleInitException;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideHandler;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.api.util.DefaultHashMap;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class ModuleRegistry {
    public static final ModuleRegistry INSTANCE = new ModuleRegistry();
    public ArrayList<ModuleInstance> modules = new ArrayList();
    public HashMap<String, ModuleFactory> IDtoModuleFactory = new HashMap();
    public HashMap<String, OverrideDefaultMethod> IDtoOverrideDefaultMethod = new HashMap();

    private ModuleRegistry() {
    }

    public ModuleInstance getModule(String id) {
        for (ModuleInstance module : this.modules) {
            if (!module.getSubModuleID().equals(id)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public ModuleInstance getModule(ItemStack itemStack) {
        for (ModuleInstance module : this.modules) {
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)module.getItemStack())) continue;
            return module;
        }
        return null;
    }

    @Nonnull
    public ArrayList<ModuleInstance> getModules(ModuleType type) {
        ArrayList<ModuleInstance> modules = new ArrayList<ModuleInstance>();
        for (ModuleInstance module : this.modules) {
            if (module.getModuleType() != type) continue;
            modules.add(module);
        }
        modules.sort(Comparator.comparing(ModuleInstance::getReadableName));
        return modules;
    }

    public void loadUnprocessedModules() {
        this.IDtoModuleFactory.clear();
        AnnotationHelper.INSTANCE.findAnnotatedClasses(LibrarianLib.PROXY.getAsmDataTable(), IModule.class, RegisterModule.class, (clazz, info) -> {
            try {
                String id = info.getString("ID");
                if (id == null) {
                    throw new ModuleInitException("Missing ID for module class " + clazz);
                }
                if (IModule.class.isAssignableFrom((Class<?>)clazz)) {
                    ModuleFactory entry = new ModuleFactory(id, (Class<? extends IModule>)clazz);
                    this.IDtoModuleFactory.put(id, entry);
                }
            }
            catch (ModuleInitException exc) {
                Wizardry.logger.error("Error occurred while registering a module class '" + clazz + "'.", (Throwable)exc);
            }
            return null;
        });
    }

    public void loadOverrideDefaults() {
        this.IDtoOverrideDefaultMethod.clear();
        AnnotationHelper.INSTANCE.findAnnotatedClasses(LibrarianLib.PROXY.getAsmDataTable(), Object.class, RegisterOverrideDefaults.class, (clazz, info) -> {
            try {
                Constructor ctor = clazz.getConstructor(new Class[0]);
                Object obj = ctor.newInstance(new Object[0]);
                this.registerOverrideDefaults((Class<?>)clazz, obj);
            }
            catch (ModuleInitException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
                Wizardry.logger.error("Error occurred while registering an override generics '" + clazz + "'.", (Throwable)exc);
            }
            return null;
        });
    }

    private void registerOverrideDefaults(Class<?> clazz, Object obj) throws ModuleInitException {
        HashMap<String, ModuleOverrideHandler.OverrideMethod> overrides = ModuleOverrideHandler.getOverrideMethodsFromClass(clazz, false);
        for (Map.Entry<String, ModuleOverrideHandler.OverrideMethod> override : overrides.entrySet()) {
            OverrideDefaultMethod methodEntry = this.IDtoOverrideDefaultMethod.get(override.getKey());
            if (methodEntry != null) {
                throw new ModuleInitException("Override '" + override.getKey() + "' is already existing at '" + methodEntry.obj.getClass() + "'. Duplicate entry found in '" + clazz + "'.");
            }
            methodEntry = new OverrideDefaultMethod(override.getKey(), override.getValue(), obj);
            this.IDtoOverrideDefaultMethod.put(override.getKey(), methodEntry);
        }
    }

    public void loadModules(File directory) {
        String[] files;
        Wizardry.logger.info(" _______________________________________________________________________\\\\");
        Wizardry.logger.info(" | Starting module registration");
        this.modules.clear();
        for (String fName : files = directory.list()) {
            IModule moduleClass;
            JsonElement element;
            File file = new File(directory, fName);
            if (ConfigValues.debugInfo) {
                Wizardry.logger.info(" | |");
                Wizardry.logger.info(" | |_ Parsing module configuration " + fName);
            }
            if (!file.exists()) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! " + file.getName() + " does NOT exist.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! " + file.getName() + " does NOT exist.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            if (!file.canRead()) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Something is preventing me from reading " + file.getName());
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                } else {
                    Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Something is preventing me from reading " + file.getName());
                    Wizardry.logger.error("|___ Failed to parse " + fName);
                }
            }
            try {
                element = new JsonParser().parse((Reader)new FileReader(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            if (element == null) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Could not parse " + fName + ". Invalid json.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Could not parse " + fName + ". Invalid json.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            if (!element.isJsonObject()) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! " + fName + "'s json is NOT a Json Object.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! " + fName + "'s json is NOT a Json Object.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            JsonObject moduleObject = element.getAsJsonObject();
            if (!moduleObject.has("reference_module_id") || !moduleObject.get("reference_module_id").isJsonPrimitive()) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! No valid 'reference_module_id' key found in " + file.getName() + ". Unknown module class to use for element.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! No valid 'reference_module_id' key found in " + file.getName() + ". Unknown module class to use for element.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            String moduleClassID = moduleObject.get("reference_module_id").getAsString();
            ModuleFactory moduleClassFactory = this.IDtoModuleFactory.get(moduleClassID);
            if (moduleClassFactory == null) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Referenced type " + moduleClassID + " is unknown.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Referenced type " + moduleClassID + " is unknown.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            if (!moduleObject.has("sub_module_id") || !moduleObject.get("sub_module_id").isJsonPrimitive()) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! No valid 'sub_module_id' key found in " + file.getName() + ". Unknown name to use for element.");
                    Wizardry.logger.error("| |___ Failed to parse " + fName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! No valid 'sub_module_id' key found in " + file.getName() + ". Unknown name to use for element.");
                Wizardry.logger.error("|___ Failed to parse " + fName);
                continue;
            }
            String moduleName = moduleObject.get("sub_module_id").getAsString();
            Wizardry.logger.info(" | | |_ Registering module " + moduleName + " of class " + moduleClassID);
            ResourceLocation icon = null;
            if (moduleObject.has("icon")) {
                if (!moduleObject.get("icon").isJsonPrimitive()) {
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Field 'icon' has an invalid type in " + file.getName() + ". It is expected to be a string.");
                        Wizardry.logger.error("| |___ Failed to register module " + moduleName);
                        continue;
                    }
                    Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Field 'icon' has an invalid type in " + file.getName() + ". It is expected to be a string.");
                    Wizardry.logger.error("|___ Failed to register module " + moduleName);
                    continue;
                }
                String iconID = moduleObject.get("icon").getAsString();
                icon = new ResourceLocation(iconID);
            }
            try {
                if (moduleObject.has("parameters")) {
                    if (!moduleObject.get("parameters").isJsonObject()) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Field 'parameters' has an invalid type in " + file.getName() + ". It is expected to be an object.");
                            Wizardry.logger.error("| |___ Failed to register module " + moduleName);
                            continue;
                        }
                        Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Field 'parameters' has an invalid type in " + file.getName() + ". It is expected to be an object.");
                        Wizardry.logger.error("|___ Failed to register module " + moduleName);
                        continue;
                    }
                    JsonObject parameters = moduleObject.getAsJsonObject("parameters");
                    HashMap<String, Object> keyToValues = new HashMap<String, Object>();
                    this.loadModuleClassParameters(keyToValues, null, parameters);
                    Iterator<Map.Entry<String, Object>> iter = keyToValues.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, Object> pair = iter.next();
                        if (moduleClassFactory.hasConfigField(pair.getKey())) continue;
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.warn("| | |_ WARNING: Parameter field '" + pair.getKey() + "' is not supported by type '" + moduleClassID + "'. Field is ignored.");
                        } else {
                            Wizardry.logger.warn("| |_ WARNING: Parameter field '" + pair.getKey() + "' is not supported by type '" + moduleClassID + "'. Field is ignored.");
                        }
                        iter.remove();
                    }
                    moduleClass = moduleClassFactory.getInstance(keyToValues);
                } else {
                    moduleClass = moduleClassFactory.getInstance();
                }
            }
            catch (ModuleInitException exc) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! " + exc.getMessage());
                    Wizardry.logger.error("| |___ Failed to register module " + moduleName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! " + exc.getMessage());
                Wizardry.logger.error("|___ Failed to register module " + moduleName);
                continue;
            }
            if (!moduleObject.has("item")) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! No 'item' key found in " + file.getName() + ". Unknown item to use for element.");
                    Wizardry.logger.error("| |___ Failed to register module " + moduleName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! No 'item' key found in " + file.getName() + ". Unknown item to use for element.");
                Wizardry.logger.error("|___ Failed to register module " + moduleName);
                continue;
            }
            Color primaryColor = Color.WHITE;
            Color secondaryColor = Color.WHITE;
            int itemMeta = 0;
            DefaultHashMap<AttributeRegistry.Attribute, AttributeRange> attributeRanges = new DefaultHashMap<AttributeRegistry.Attribute, AttributeRange>(AttributeRange.BACKUP);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(moduleObject.getAsJsonPrimitive("item").getAsString()));
            if (item == null || item.getRegistryName() == null) {
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.error("| | |_ SOMETHING WENT WRONG! Item for module " + moduleName + " does not exist '" + moduleObject.getAsJsonPrimitive("item").getAsString() + "'");
                    Wizardry.logger.error("| |___ Failed to register module " + moduleName);
                    continue;
                }
                Wizardry.logger.error("| |_ SOMETHING WENT WRONG! Item for module " + moduleName + " does not exist '" + moduleObject.getAsJsonPrimitive("item").getAsString() + "'");
                Wizardry.logger.error("|___ Failed to register module " + moduleName);
                continue;
            }
            if (ConfigValues.debugInfo) {
                Wizardry.logger.info(" | | |_ Found Item " + item.getRegistryName().toString());
            }
            attributeRanges.put(AttributeRegistry.BURNOUT_MULTI, new AttributeRange(1.0, 0.0, 2.147483647E9));
            attributeRanges.put(AttributeRegistry.MANA_MULTI, new AttributeRange(1.0, 0.0, 2.147483647E9));
            attributeRanges.put(AttributeRegistry.POWER_MULTI, new AttributeRange(1.0, 0.0, 2.147483647E9));
            block16: for (Map.Entry entry : moduleObject.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "meta": {
                        itemMeta = ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsInt();
                        if (!ConfigValues.debugInfo) continue block16;
                        Wizardry.logger.info(" | | |_ Found Item Meta:          " + itemMeta);
                        continue block16;
                    }
                    case "primary_color": {
                        primaryColor = new Color(Integer.parseInt(((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString(), 16));
                        if (!ConfigValues.debugInfo) continue block16;
                        Wizardry.logger.info(" | | |_ Found Primary Color:      " + primaryColor.getRGB());
                        continue block16;
                    }
                    case "secondary_color": {
                        secondaryColor = new Color(Integer.parseInt(((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString(), 16));
                        if (!ConfigValues.debugInfo) continue block16;
                        Wizardry.logger.info(" | | |_ Found Secondary Color:    " + secondaryColor.getRGB());
                        continue block16;
                    }
                }
                AttributeRegistry.Attribute attribute = AttributeRegistry.getAttributeFromName((String)entry.getKey());
                if (attribute == null) continue;
                if (ConfigValues.debugInfo) {
                    Wizardry.logger.info(" | | |_ Found base " + attribute.toString() + " values:");
                }
                JsonObject baseAttrib = ((JsonElement)entry.getValue()).getAsJsonObject();
                double min = 0.0;
                if (baseAttrib.has("min") && baseAttrib.get("min").isJsonPrimitive()) {
                    min = baseAttrib.get("min").getAsInt();
                    if (min < 0.0) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.info(" | | | |_ Minimum value for " + attribute.toString() + " was " + min + ", must be a positive integer. Setting to 0");
                        }
                        min = 0.0;
                    }
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.info(" | | | |_ Minimum: " + min);
                    }
                }
                double max = 2.147483647E9;
                if (baseAttrib.has("max") && baseAttrib.get("max").isJsonPrimitive()) {
                    max = baseAttrib.get("max").getAsDouble();
                    if (max < min) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.info(" | | | |_ Maximum value for " + attribute.toString() + " was " + max + ", must be greater than min. Setting to min, " + min);
                        }
                        max = min;
                    }
                    if (max > 2.147483647E9) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.info(" | | | |_ Maximum maximum value is 2147483647, max was " + max + ". Setting to " + Integer.MAX_VALUE);
                        }
                        max = 2.147483647E9;
                    }
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.info(" | | | |_ Maximum: " + max);
                    }
                }
                double base = min;
                if (baseAttrib.has("base") && baseAttrib.get("base").isJsonPrimitive()) {
                    base = baseAttrib.get("base").getAsDouble();
                    if (base < min) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.info(" | | | |_ Base value for " + attribute.toString() + " was " + base + ", must be greater than min, " + min + ". Setting to " + min);
                        }
                        base = min;
                    } else if (base > max) {
                        if (ConfigValues.debugInfo) {
                            Wizardry.logger.info(" | | | |_ Base value for " + attribute + " was " + base + ", must be less than max, " + max + ". Setting to " + max);
                        }
                        base = max;
                    }
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.info(" | | | |_ Base: " + base);
                    }
                }
                attributeRanges.put(attribute, new AttributeRange(base, min, max));
            }
            ModuleInstance module = ModuleInstance.createInstance(moduleClass, moduleClassFactory, moduleName, icon, new ItemStack(item, 1, itemMeta), primaryColor, secondaryColor, attributeRanges);
            if (moduleObject.has("modifiers") && moduleObject.get("modifiers").isJsonArray()) {
                Wizardry.logger.info(" | | |___ Found Modifiers. About to process them");
                JsonArray attributeModifiers = moduleObject.getAsJsonArray("modifiers");
                for (JsonElement attributeModifier : attributeModifiers) {
                    if (!attributeModifier.isJsonObject()) continue;
                    String attributeName = "NULL";
                    AttributeRegistry.Attribute attribute = null;
                    Operation operator = null;
                    double amount = 0.0;
                    JsonObject modifier = attributeModifier.getAsJsonObject();
                    if (modifier.has("attribute") && modifier.get("attribute").isJsonPrimitive() && modifier.getAsJsonPrimitive("attribute").isString() && (attribute = AttributeRegistry.getAttributeFromName(modifier.getAsJsonPrimitive("attribute").getAsString())) != null) {
                        attributeName = attribute.getShortName();
                    }
                    if (modifier.has("operation") && modifier.get("operation").isJsonPrimitive() && modifier.getAsJsonPrimitive("operation").isString()) {
                        operator = Operation.valueOf(modifier.get("operation").getAsJsonPrimitive().getAsString().toUpperCase());
                    }
                    if (modifier.has("amount") && modifier.get("amount").isJsonPrimitive() && modifier.getAsJsonPrimitive("amount").isNumber()) {
                        amount = modifier.get("amount").getAsDouble();
                    }
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.info(" | | | |_ Loading AttributeModifier for " + file.getName() + ": " + (Object)((Object)operator) + " -> " + attributeName + ", " + amount);
                    }
                    if (attribute != null && operator != null) {
                        module.addAttribute(new AttributeModifier(attribute, amount, operator));
                        if (!ConfigValues.debugInfo) continue;
                        Wizardry.logger.info(" | | | | |_ AttributeModifier registered successfully");
                        continue;
                    }
                    if (ConfigValues.debugInfo) {
                        Wizardry.logger.error("| | | | |_ Failed to register AttributeModifier!");
                        continue;
                    }
                    Wizardry.logger.error("| | | |_ Failed to register AttributeModifier!");
                }
                Wizardry.logger.info(" | | |___ Modifiers Registered Successfully.");
            }
            this.modules.add(module);
            Wizardry.logger.info(" | |_ Module " + moduleName + " registered successfully!");
        }
        this.modules.sort(Comparator.comparing(ModuleInstance::getSubModuleID));
        Wizardry.logger.info(" |");
        Wizardry.logger.info(" | Module registration processing complete! (\u00e1\u00b5\u201d\u00e1\u00b4\u00a5\u00e1\u00b5\u201d)");
        Wizardry.logger.info(" |_______________________________________________________________________//");
    }

    private void loadModuleClassParameters(Map<String, Object> parameters, String prefix, JsonObject from) {
        for (Map.Entry entry : from.entrySet()) {
            JsonElement elem = (JsonElement)entry.getValue();
            String name = prefix != null && !prefix.isEmpty() ? prefix + "." + (String)entry.getKey() : (String)entry.getKey();
            if (elem.isJsonPrimitive()) {
                parameters.put(name, this.getJsonValue(name, elem.getAsJsonPrimitive()));
                continue;
            }
            if (elem.isJsonObject()) {
                this.loadModuleClassParameters(parameters, name, elem.getAsJsonObject());
                continue;
            }
            Wizardry.logger.warn("| | |_ WARNING! Ignoring parameter '" + name + "' having an invalid type. It is expected to be either a primitive or an object.");
        }
    }

    private Object getJsonValue(String key, JsonPrimitive elem) {
        if (elem.isString()) {
            return elem.getAsString();
        }
        if (elem.isNumber()) {
            return elem.getAsNumber();
        }
        if (elem.isBoolean()) {
            return elem.getAsBoolean();
        }
        String value = elem.getAsString();
        Wizardry.logger.warn("| | |_ WARNING! Using fallback as string for parameter '" + key + "' having value '" + value + "'.");
        return value;
    }

    public void copyMissingModules(File directory) {
        for (ModuleInstance module : this.modules) {
            File file = new File(directory + "/modules/", module.getSubModuleID() + ".json");
            if (file.exists()) continue;
            InputStream stream = LibrarianLib.PROXY.getResource("wizardry", "modules/" + module.getSubModuleID() + ".json");
            if (stream == null) {
                Wizardry.logger.error("    > SOMETHING WENT WRONG! Could not read module " + module.getSubModuleID() + " from mod jar! Report this to the devs on Github!");
                continue;
            }
            try {
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
                Wizardry.logger.info("    > Module " + module.getSubModuleID() + " copied successfully from mod jar.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void copyAllModules(File directory) {
        Map modList = Loader.instance().getIndexedModList();
        for (Map.Entry entry : modList.entrySet()) {
            for (ModuleInstance module : this.modules) {
                InputStream stream = LibrarianLib.PROXY.getResource((String)entry.getKey(), "wizmodules/" + module.getSubModuleID() + ".json");
                if (stream == null) {
                    Wizardry.logger.error("    > SOMETHING WENT WRONG! Could not read module " + module.getSubModuleID() + " from mod jar of '" + (String)entry.getKey() + "'! Report this to the devs on Github!");
                    continue;
                }
                try {
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File(directory + "/wizmodules/", module.getSubModuleID() + ".json"));
                    Wizardry.logger.info("    > Module " + module.getSubModuleID() + " copied successfully from mod jar.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    Map<String, OverrideDefaultMethod> getDefaultOverrides() {
        return Collections.unmodifiableMap(this.IDtoOverrideDefaultMethod);
    }

    static class OverrideDefaultMethod {
        private final String overrideName;
        private final ModuleOverrideHandler.OverrideMethod method;
        private final Object obj;

        OverrideDefaultMethod(String overrideName, ModuleOverrideHandler.OverrideMethod method, Object obj) {
            this.overrideName = overrideName;
            this.method = method;
            this.obj = obj;
        }

        String getOverrideName() {
            return this.overrideName;
        }

        ModuleOverrideHandler.OverrideMethod getMethod() {
            return this.method;
        }

        Object getObj() {
            return this.obj;
        }
    }
}

