/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextSuper;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverrideInterface;
import com.teamwizardry.wizardry.api.spell.module.ModuleInitException;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideException;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideSuper;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ModuleOverrideHandler {
    private HashMap<String, OverridePointer> overridePointers = new HashMap();
    private HashMap<String, Object> cachedProxies = new HashMap();
    private final SpellRing spellChain;

    public ModuleOverrideHandler(SpellRing spellChain) throws ModuleOverrideException {
        SpellRing[] spellSequence;
        this.spellChain = spellChain;
        if (spellChain.getParentRing() != null) {
            throw new IllegalArgumentException("passed spellRing is not a root.");
        }
        for (ModuleRegistry.OverrideDefaultMethod methodEntry : ModuleRegistry.INSTANCE.getDefaultOverrides().values()) {
            this.applyDefaultOverride(methodEntry);
        }
        for (SpellRing curRing : spellSequence = ModuleOverrideHandler.getSequenceFromSpellChain(spellChain)) {
            this.applyModuleOverrides(curRing);
        }
    }

    public synchronized <T> T getConsumerInterface(Class<T> interfaceClass) throws ModuleOverrideException {
        String className = interfaceClass.getName();
        Object obj = this.cachedProxies.get(className);
        if (obj == null) {
            T newProxy = this.createConsumerInterface(interfaceClass);
            this.cachedProxies.put(className, newProxy);
            return newProxy;
        }
        if (!interfaceClass.isInstance(obj)) {
            throw new IllegalStateException("Incompatible interface class with matching name. Class loader different?");
        }
        return (T)obj;
    }

    private <T> T createConsumerInterface(Class<T> interfaceClass) throws ModuleOverrideException {
        Map<String, Method> overridableMethods = ModuleOverrideHandler.getInterfaceMethods(interfaceClass);
        OverrideInvoker invocationHandler = new OverrideInvoker(overridableMethods, interfaceClass.getName());
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        Class[] proxyInterfaces = new Class[]{interfaceClass};
        Object proxy = Proxy.newProxyInstance(myClassLoader, proxyInterfaces, (InvocationHandler)invocationHandler);
        return (T)proxy;
    }

    private void applyModuleOverrides(SpellRing spellRing) throws ModuleOverrideException {
        ModuleInstance module = spellRing.getModule();
        Map<String, OverrideMethod> overrides = module.getFactory().getOverrides();
        for (Map.Entry<String, OverrideMethod> entry : overrides.entrySet()) {
            OverridePointer ptr = this.overridePointers.get(entry.getKey());
            if (ptr == null) {
                ptr = new OverridePointer(spellRing, null, entry.getKey(), entry.getValue());
            } else {
                if (!ModuleOverrideHandler.areMethodsCompatible(ptr.getBaseMethod().getMethod(), entry.getValue().getMethod())) {
                    throw new ModuleOverrideException("Method '" + ptr.getBaseMethod() + "' can't be overridden by '" + entry.getValue() + "' due to incompatible signature.");
                }
                ptr = new OverridePointer(spellRing, ptr, entry.getKey(), entry.getValue());
            }
            this.overridePointers.put(entry.getKey(), ptr);
        }
    }

    private void applyDefaultOverride(ModuleRegistry.OverrideDefaultMethod methodEntry) {
        if (this.overridePointers.containsKey(methodEntry.getOverrideName())) {
            throw new IllegalStateException("Duplicate override found.");
        }
        OverridePointer ptr = new OverridePointer(methodEntry);
        this.overridePointers.put(methodEntry.getOverrideName(), ptr);
    }

    private static SpellRing[] getSequenceFromSpellChain(SpellRing spellRing) {
        LinkedList<SpellRing> instances = new LinkedList<SpellRing>();
        for (SpellRing cur = spellRing; cur != null; cur = cur.getChildRing()) {
            ModuleInstance module = cur.getModule();
            if (!module.getFactory().hasOverrides()) continue;
            instances.add(cur);
        }
        return instances.toArray(new SpellRing[instances.size()]);
    }

    private static boolean areMethodsCompatible(Method baseMtd, Method overrideMtd) {
        Class<?>[] overrideExcps;
        Class<?> baseReturnType = baseMtd.getReturnType();
        Class<?> overrideReturnType = overrideMtd.getReturnType();
        if (baseReturnType == null) {
            if (overrideReturnType != null) {
                return false;
            }
        } else {
            if (overrideReturnType == null) {
                return false;
            }
            if (!baseReturnType.isAssignableFrom(overrideReturnType)) {
                return false;
            }
        }
        Parameter[] baseParams = baseMtd.getParameters();
        Parameter[] overrideParams = overrideMtd.getParameters();
        int i = 0;
        int j = 0;
        while (i < baseParams.length || j < baseParams.length) {
            Parameter baseParam;
            if (i >= baseParams.length) {
                while (j < overrideParams.length) {
                    Parameter overrideParam = overrideParams[j];
                    if (!ModuleOverrideHandler.isExtraParameter(overrideParam)) {
                        return false;
                    }
                    ++j;
                }
                break;
            }
            if (j >= overrideParams.length) {
                while (i < overrideParams.length) {
                    baseParam = baseParams[i];
                    if (!ModuleOverrideHandler.isExtraParameter(baseParam)) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            baseParam = baseParams[i];
            if (ModuleOverrideHandler.isExtraParameter(baseParam)) {
                ++i;
                continue;
            }
            Parameter overrideParam = overrideParams[j];
            if (ModuleOverrideHandler.isExtraParameter(overrideParam)) {
                ++j;
                continue;
            }
            if (!baseParam.getType().isAssignableFrom(overrideParam.getType())) {
                return false;
            }
            ++i;
            ++j;
        }
        Class<?>[] baseExcps = baseMtd.getExceptionTypes();
        for (Class<?> overrideExcp : overrideExcps = overrideMtd.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(overrideExcp)) continue;
            boolean found = false;
            for (Class<?> baseExcp : baseExcps) {
                if (RuntimeException.class.isAssignableFrom(baseExcp) || !baseExcp.isAssignableFrom(overrideExcp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean isExtraParameter(Parameter param) {
        return param.isAnnotationPresent(ContextRing.class) || param.isAnnotationPresent(ContextSuper.class);
    }

    static HashMap<String, OverrideMethod> getOverrideMethodsFromClass(Class<?> clazz, boolean hasContext) throws ModuleInitException {
        HashMap<String, OverrideMethod> overridableMethods = new HashMap<String, OverrideMethod>();
        for (Method method : clazz.getMethods()) {
            ModuleOverride ovrd = method.getDeclaredAnnotation(ModuleOverride.class);
            if (ovrd == null) continue;
            if (overridableMethods.containsKey(ovrd.value())) {
                throw new ModuleInitException("Multiple methods exist in class '" + clazz + "' with same override name '" + ovrd.value() + "'.");
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new ModuleInitException("Failed to aquire reflection access to method '" + method.toString() + "', annotated by @ModuleOverride.", e);
            }
            int idxContextParamRing = -1;
            int idxContextParamSuper = -2;
            Parameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                Parameter param = params[i];
                if (param.isAnnotationPresent(ContextRing.class)) {
                    if (idxContextParamRing >= 0) {
                        throw new ModuleInitException("Method '" + method.toString() + "' has invalid @ContextRing annotated parameter. It is not allowed on multiple parameters.");
                    }
                    idxContextParamRing = i;
                }
                if (!param.isAnnotationPresent(ContextSuper.class)) continue;
                if (idxContextParamSuper >= 0) {
                    throw new ModuleInitException("Method '" + method.toString() + "' has invalid @ContextSuper annotated parameter. It is not allowed on multiple parameters.");
                }
                idxContextParamSuper = i;
            }
            if (!(hasContext || idxContextParamRing < 0 && idxContextParamSuper < 0)) {
                throw new ModuleInitException("Context parameters are not allowed.");
            }
            if (idxContextParamRing == idxContextParamSuper) {
                throw new ModuleInitException("Method '" + method.toString() + "' has a parameter which is annotated with multiple roles.");
            }
            OverrideMethod ovrdMethod = new OverrideMethod(method, idxContextParamRing, idxContextParamSuper);
            overridableMethods.put(ovrd.value(), ovrdMethod);
        }
        return overridableMethods;
    }

    public static Map<String, Method> getInterfaceMethods(Class<?> clazz) throws ModuleOverrideException {
        HashMap<String, Method> overridableMethods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            ModuleOverrideInterface ovrd = method.getDeclaredAnnotation(ModuleOverrideInterface.class);
            if (ovrd == null) continue;
            if (overridableMethods.containsKey(ovrd.value())) {
                throw new ModuleOverrideException("Multiple methods exist in class '" + clazz + "' with same override name '" + ovrd.value() + "'.");
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new ModuleOverrideException("Failed to aquire reflection access to method '" + method.toString() + "', annotated by @ModuleOverrideInterface.", e);
            }
            overridableMethods.put(ovrd.value(), method);
        }
        return overridableMethods;
    }

    static class OverrideMethod {
        private final Method method;
        private final MethodHandle methodHandle;
        private final int idxContextParamRing;
        private final int idxContextParamSuper;

        OverrideMethod(Method method, int idxContextParamRing, int idxContextParamSuper) throws ModuleInitException {
            try {
                this.method = method;
                this.methodHandle = MethodHandles.lookup().unreflect(method);
                this.idxContextParamRing = idxContextParamRing >= 0 ? idxContextParamRing : -2;
                this.idxContextParamSuper = idxContextParamSuper >= 0 ? idxContextParamSuper : -2;
            }
            catch (Exception e) {
                throw new ModuleInitException("Couldn't initialize override method binding. See cause.", e);
            }
        }

        Method getMethod() {
            return this.method;
        }

        MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        int getIdxContextParamRing() {
            return this.idxContextParamRing;
        }

        int getIdxContextParamSuper() {
            return this.idxContextParamSuper;
        }
    }

    private static class OverrideInterfaceMethod {
        private final OverridePointer overridePointer;
        private final Method interfaceMethod;

        OverrideInterfaceMethod(OverridePointer overridePointer, Method interfaceMethod) {
            this.overridePointer = overridePointer;
            this.interfaceMethod = interfaceMethod;
        }

        OverridePointer getOverridePointer() {
            return this.overridePointer;
        }

        Method getInterfaceMethod() {
            return this.interfaceMethod;
        }

        String getKey() {
            return this.interfaceMethod.getName();
        }
    }

    static class OverridePointer {
        private final Object object;
        private final SpellRing spellRingWithOverride;
        private final String overrideName;
        private final OverrideMethod baseMethod;
        private final OverridePointer prev;

        OverridePointer(SpellRing spellRingWithOverride, OverridePointer prev, String overrideName, OverrideMethod baseMethod) {
            this.spellRingWithOverride = spellRingWithOverride;
            this.baseMethod = baseMethod;
            this.overrideName = overrideName;
            this.prev = prev;
            this.object = this.getModule().getModuleClass();
        }

        public OverridePointer(ModuleRegistry.OverrideDefaultMethod methodEntry) {
            this.spellRingWithOverride = null;
            this.baseMethod = methodEntry.getMethod();
            this.overrideName = methodEntry.getOverrideName();
            this.prev = null;
            this.object = methodEntry.getObj();
        }

        SpellRing getSpellRingWithOverride() {
            return this.spellRingWithOverride;
        }

        OverrideMethod getBaseMethod() {
            return this.baseMethod;
        }

        ModuleInstance getModule() {
            if (this.spellRingWithOverride == null) {
                return null;
            }
            return this.spellRingWithOverride.getModule();
        }

        OverridePointer getPrev() {
            return this.prev;
        }

        String getOverrideName() {
            return this.overrideName;
        }

        Object invoke(Object[] args) throws Throwable {
            int idxContextParamRing = this.baseMethod.getIdxContextParamRing();
            int idxContextParamSuper = this.baseMethod.getIdxContextParamSuper();
            Object[] passedArgs = args;
            int countExtra = 1;
            if (idxContextParamRing >= 0) {
                ++countExtra;
            }
            if (idxContextParamSuper >= 0) {
                ++countExtra;
            }
            passedArgs = new Object[args.length + countExtra];
            int j = 0;
            for (int i = 0; i < passedArgs.length; ++i) {
                if (i == 0) {
                    passedArgs[i] = this.object;
                    continue;
                }
                if (i == idxContextParamRing + 1) {
                    passedArgs[i] = this.spellRingWithOverride;
                    continue;
                }
                if (i == idxContextParamSuper + 1) {
                    passedArgs[i] = new ModuleOverrideSuper(this.prev);
                    continue;
                }
                passedArgs[i] = args[j];
                ++j;
            }
            try {
                return this.baseMethod.getMethodHandle().invokeWithArguments(passedArgs);
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                throw new IllegalStateException("Couldn't invoke call. See cause.", e);
            }
        }
    }

    private class OverrideInvoker
    implements InvocationHandler {
        private final HashMap<String, OverrideInterfaceMethod> callMap = new HashMap();
        private final String displayedInterfaceName;

        public OverrideInvoker(Map<String, Method> interfaceMethods, String displayedInterfaceName) throws ModuleOverrideException {
            this.displayedInterfaceName = displayedInterfaceName;
            for (Map.Entry<String, Method> interfaceMethod : interfaceMethods.entrySet()) {
                OverridePointer ptr = (OverridePointer)ModuleOverrideHandler.this.overridePointers.get(interfaceMethod.getKey());
                if (ptr == null) continue;
                if (!ModuleOverrideHandler.areMethodsCompatible(interfaceMethod.getValue(), ptr.getBaseMethod().getMethod())) {
                    throw new ModuleOverrideException("Interface method signature of '" + interfaceMethod.getValue() + "' is incompatible with '" + ptr.getBaseMethod().getMethod() + "'.");
                }
                OverrideInterfaceMethod intfMethodEntry = new OverrideInterfaceMethod(ptr, interfaceMethod.getValue());
                this.callMap.put(intfMethodEntry.getKey(), intfMethodEntry);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            OverrideInterfaceMethod intfMethod = this.callMap.get(name);
            if (intfMethod == null) {
                if (this.isMethodToString(method)) {
                    return "Proxy for '" + this.displayedInterfaceName + "' on " + ModuleOverrideHandler.this.spellChain;
                }
                if (this.isMethodHashCode(method)) {
                    return 0;
                }
                if (this.isMethodEquals(method)) {
                    return proxy == args[0];
                }
                if (this.isMethodClone(method)) {
                    throw new CloneNotSupportedException("Override handler has no clone ability.");
                }
                ModuleOverrideInterface annot = method.getDeclaredAnnotation(ModuleOverrideInterface.class);
                if (annot != null) {
                    throw new UnsupportedOperationException("Override method for '" + annot.value() + "' invoke via '" + method + "' is not implemented or not public.");
                }
                throw new UnsupportedOperationException("Method '" + method + "' is not an override. Annotation @ModuleOverrideInterface must be supplied.");
            }
            OverridePointer ptr = intfMethod.getOverridePointer();
            return ptr.invoke(args);
        }

        private boolean isMethodHashCode(Method method) {
            if (method == null) {
                return false;
            }
            if (method.getParameterCount() != 0) {
                return false;
            }
            if (!Integer.TYPE.equals(method.getReturnType())) {
                return false;
            }
            return "hashCode".equals(method.getName());
        }

        private boolean isMethodEquals(Method method) {
            if (method == null) {
                return false;
            }
            if (method.getParameterCount() != 1) {
                return false;
            }
            if (!method.getParameterTypes()[0].equals(Object.class)) {
                return false;
            }
            if (!Boolean.TYPE.equals(method.getReturnType())) {
                return false;
            }
            return "equals".equals(method.getName());
        }

        private boolean isMethodToString(Method method) {
            if (method == null) {
                return false;
            }
            if (method.getParameterCount() != 0) {
                return false;
            }
            if (!String.class.equals(method.getReturnType())) {
                return false;
            }
            return "toString".equals(method.getName());
        }

        private boolean isMethodClone(Method method) {
            if (method == null) {
                return false;
            }
            if (method.getParameterCount() != 0) {
                return false;
            }
            if (!Object.class.equals(method.getReturnType())) {
                return false;
            }
            return "clone".equals(method.getName());
        }
    }
}

