/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellRingCache;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SpellBuilder {
    private List<ItemStack> inventory;
    private List<SpellRing> spell;

    public SpellBuilder(List<ItemStack> inventory) {
        this.inventory = inventory;
        this.spell = this.toSpell(inventory, 1.0);
    }

    public SpellBuilder(List<ItemStack> inventory, double pearlMultiplier) {
        this.inventory = inventory;
        this.spell = this.toSpell(inventory, pearlMultiplier);
    }

    @Nonnull
    private static List<List<ItemStack>> brancher(List<ItemStack> inventory, Item identifier) {
        ArrayList<List<ItemStack>> branches = new ArrayList<List<ItemStack>>();
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (ItemStack stack : inventory) {
            if (ItemStack.func_179545_c((ItemStack)new ItemStack(identifier), (ItemStack)stack)) {
                if (!temp.isEmpty()) {
                    branches.add(temp);
                }
                temp = new ArrayList();
                continue;
            }
            temp.add(stack);
        }
        if (!temp.isEmpty()) {
            branches.add(temp);
        }
        return branches;
    }

    private List<SpellRing> toSpell(List<ItemStack> inventory, double pearlMultiplier) {
        ArrayList<SpellRing> spellList = new ArrayList<SpellRing>();
        HashSet spellChains = new HashSet();
        List<List<ItemStack>> lines = SpellBuilder.brancher(inventory, SpellUtils.CODE_LINE_BREAK);
        for (List<ItemStack> list : lines) {
            ArrayDeque<SpellRing> uncompressedChain = new ArrayDeque<SpellRing>();
            for (ItemStack stack : list) {
                int i;
                ModuleInstance module = ModuleRegistry.INSTANCE.getModule(stack);
                if (module == null) continue;
                if (module instanceof ModuleInstanceModifier) {
                    if (uncompressedChain.isEmpty()) continue;
                    for (i = 0; i < stack.func_190916_E(); ++i) {
                        SpellRing lastRing = (SpellRing)uncompressedChain.peekLast();
                        lastRing.addModifier((ModuleInstanceModifier)module);
                    }
                    continue;
                }
                for (i = 0; i < stack.func_190916_E(); ++i) {
                    SpellRing ring = new SpellRing(module);
                    uncompressedChain.add(ring);
                }
            }
            spellChains.add(new ArrayList(uncompressedChain));
        }
        for (List<Object> list : spellChains) {
            SpellRing ringHead;
            if (list.isEmpty()) continue;
            ArrayDeque<Object> deque = new ArrayDeque<Object>(list);
            SpellRing lastRing = ringHead = (SpellRing)deque.pop();
            while (!deque.isEmpty()) {
                SpellRing child = (SpellRing)deque.pop();
                lastRing.setChildRing(child);
                child.setParentRing(lastRing);
                lastRing = child;
            }
            spellList.add(ringHead);
        }
        Iterator<List<Object>> iterator = spellList.iterator();
        while (iterator.hasNext()) {
            SpellRing spellRing;
            LinkedList cascadingModifiers = new LinkedList();
            for (SpellRing chainEnd = spellRing = (SpellRing)((Object)iterator.next()); chainEnd != null; chainEnd = chainEnd.getChildRing()) {
                for (ModuleInstanceModifier modifier : cascadingModifiers) {
                    chainEnd.addModifier(modifier);
                }
                if (chainEnd.getChildRing() == null) {
                    if (chainEnd.getModule() != null) {
                        chainEnd.setPrimaryColor(chainEnd.getModule().getPrimaryColor());
                        chainEnd.setSecondaryColor(chainEnd.getModule().getSecondaryColor());
                    }
                    chainEnd.updateColorChain();
                }
                chainEnd.processModifiers();
            }
        }
        ArrayList<SpellRing> cachedSpellList = new ArrayList<SpellRing>(spellList.size());
        for (SpellRing ring : spellList) {
            SpellRing cachedRing = SpellRingCache.INSTANCE.internalGetSpellRingByNBT(ring.serializeNBT(), false);
            if (cachedRing != null) {
                cachedSpellList.add(cachedRing);
                continue;
            }
            ring = SpellRingCache.INSTANCE.registerSpellRing(ring);
            cachedSpellList.add(ring);
        }
        return cachedSpellList;
    }

    public List<ItemStack> getInventory() {
        return this.inventory;
    }

    public List<SpellRing> getSpell() {
        return this.spell;
    }
}

