/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.blockstate;

import codechicken.lib.model.loader.blockstate.CCBlockStateLoader;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.TransformUtils;
import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class CCVariant
implements Copyable<CCVariant> {
    protected ResourceLocation model;
    protected Optional<IModelState> state = Optional.empty();
    protected Optional<Boolean> uvLock = Optional.empty();
    protected Optional<Boolean> smooth = Optional.empty();
    protected Optional<Boolean> gui3d = Optional.empty();
    protected Optional<Integer> weight = Optional.empty();
    protected Map<String, String> textures = new HashMap<String, String>();
    protected Map<String, String> customData = new HashMap<String, String>();
    protected Map<String, Map<String, CCVariant>> subVariants = new LinkedHashMap<String, Map<String, CCVariant>>();

    public CCVariant() {
    }

    public CCVariant(CCVariant variant) {
        this.model = variant.model;
        this.state = variant.state;
        this.uvLock = variant.uvLock;
        this.smooth = variant.smooth;
        this.gui3d = variant.gui3d;
        this.weight = variant.weight;
        this.textures = new HashMap<String, String>(variant.textures);
        this.customData = new HashMap<String, String>(this.customData);
        this.subVariants = new LinkedHashMap<String, Map<String, CCVariant>>(variant.subVariants);
    }

    public CCVariant with(CCVariant other) {
        if (this.model == null || other.model != null) {
            this.model = other.model;
        }
        if (other.state.isPresent()) {
            this.state = other.state;
        }
        if (other.uvLock.isPresent()) {
            this.uvLock = other.uvLock;
        }
        if (other.smooth.isPresent()) {
            this.smooth = other.smooth;
        }
        if (other.gui3d.isPresent()) {
            this.gui3d = other.gui3d;
        }
        if (other.weight.isPresent()) {
            this.weight = other.weight;
        }
        HashMap<String, String> newTextures = new HashMap<String, String>();
        newTextures.putAll(this.textures);
        newTextures.putAll(other.textures);
        this.textures = new LinkedHashMap<String, String>(newTextures);
        HashMap<String, String> newCustomData = new HashMap<String, String>();
        newCustomData.putAll(this.customData);
        newCustomData.putAll(other.customData);
        this.customData = new LinkedHashMap<String, String>(newCustomData);
        return this;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public boolean hasTextures() {
        return this.textures.size() != 0;
    }

    public boolean hasCustomData() {
        return this.customData.size() != 0;
    }

    public List<String> getPossibleVariantNames() {
        ArrayList<String> variantNames = new ArrayList<String>();
        for (String variantName : this.subVariants.keySet()) {
            variantNames.add(variantName);
            for (CCVariant subVariant : this.subVariants.get(variantName).values()) {
                variantNames.addAll(subVariant.getPossibleVariantNames());
            }
        }
        return variantNames;
    }

    public List<String> getPossibleVariantValues(String variant) {
        ArrayList<String> variantValues = new ArrayList<String>();
        for (String variantName : this.subVariants.keySet()) {
            if (variantName.equals(variant) && this.subVariants.containsKey(variant)) {
                variantValues.addAll(this.subVariants.get(variant).keySet());
            }
            for (CCVariant subVariant : this.subVariants.get(variantName).values()) {
                variantValues.addAll(subVariant.getPossibleVariantValues(variant));
            }
        }
        return variantValues;
    }

    public CCVariant applySubOverrides(CCVariant parent, Map<String, String> kvArray) {
        Map<String, CCVariant> variantMap;
        CCVariant finalVariant = parent;
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : this.subVariants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = finalVariant.with(variantMap.get(entry.getValue()));
            }
        }
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : this.subVariants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = variantMap.get(entry.getValue()).applySubOverrides(finalVariant, kvArray);
            }
        }
        return finalVariant;
    }

    @Override
    public CCVariant copy() {
        return new CCVariant(this);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CCVariant");
        helper.add("Model", (Object)this.model);
        helper.add("IModelState", this.state);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        helper.add("Textures:", (Object)gson.toJson(this.textures, Map.class));
        return helper.toString();
    }

    public static class Deserializer
    implements JsonDeserializer<CCVariant> {
        public static ResourceLocation getBlockLocation(String location) {
            ResourceLocation tmp = new ResourceLocation(location);
            return new ResourceLocation(tmp.func_110624_b(), "block/" + tmp.func_110623_a());
        }

        public CCVariant deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CCVariant variant = new CCVariant();
            JsonObject json = element.getAsJsonObject();
            if (json.has("model")) {
                JsonElement modelElement = json.get("model");
                variant.model = modelElement.isJsonNull() ? null : Deserializer.getBlockLocation(modelElement.getAsString());
            }
            if (json.has("textures")) {
                for (Map.Entry entry : json.get("textures").getAsJsonObject().entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonNull()) {
                        variant.textures.put((String)entry.getKey(), "");
                        continue;
                    }
                    variant.textures.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            variant.state = TransformUtils.parseFromJson(json);
            if (json.has("uvlock")) {
                variant.uvLock = Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"uvlock"));
            }
            if (json.has("smooth_lighting")) {
                variant.smooth = Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"smooth_lighting"));
            }
            if (json.has("gui3d")) {
                variant.gui3d = Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"gui3d"));
            }
            if (json.has("weight")) {
                variant.weight = Optional.of(JsonUtils.func_151203_m((JsonObject)json, (String)"weight"));
            }
            if (json.has("variants")) {
                variant.subVariants.putAll(CCBlockStateLoader.parseVariants(new LinkedHashMap<String, Map<String, CCVariant>>(), json.getAsJsonObject("variants")));
            }
            if (json.has("custom")) {
                for (Map.Entry e : json.get("custom").getAsJsonObject().entrySet()) {
                    if (((JsonElement)e.getValue()).isJsonNull()) {
                        variant.customData.put((String)e.getKey(), (String)null);
                        continue;
                    }
                    variant.customData.put((String)e.getKey(), ((JsonElement)e.getValue()).toString());
                }
            }
            return variant;
        }
    }
}

