/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders;

import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class PartBuilderRecipe
extends IPartBuilder {
    private static Pattern recipePat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7recipe\\[[^\u00a7]*]\\{[^\u00a7]*})|(?<=[^\\\\]|^)(\u00a7recipe\\[[^\u00a7 ]*])");
    private static Pattern recipeStack = Pattern.compile("(?<=\u00a7recipe\\[)(.*)(?=][{])|(?<=\u00a7recipe\\[)(.*)(?=])");
    private static Pattern recipeOPS = Pattern.compile("(?<=]\\{)(.*)(?=})");

    @Override
    public int matches(String test) {
        Matcher matcher = recipePat.matcher(test);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public String build(BCFontRenderer font, String markdown, int nextPart, BCFontRenderer fr, final PartContainer container, LinkedList<Part> parts, int elementLeft, int elementRight, int xPos, int yPos, int nextYLevel) {
        ItemStack stack;
        int spacing;
        int bottomPad;
        int topPad;
        int rightPad;
        int leftPad;
        int borderColourHover;
        int borderColour;
        String ops;
        String stackString;
        GuiMarkdownElement.profiler.startSection("Build Recipe");
        this.builtHeight = font.field_78288_b;
        Matcher recipeMatch = recipePat.matcher(markdown);
        if (!recipeMatch.find(0)) {
            LogHelperBC.error("Failed to build " + this.getClass().getSimpleName() + " This suggests a false match occurred which should not be possible!");
            return "";
        }
        String match = recipeMatch.group();
        Matcher stackMatch = recipeStack.matcher(match);
        if (!stackMatch.find() || (stackString = stackMatch.group()).isEmpty()) {
            return recipeMatch.replaceFirst("[Broken recipe. No stack string Found]");
        }
        Matcher opsMatch = recipeOPS.matcher(match);
        String string = ops = opsMatch.find() ? opsMatch.group() : "";
        if (ops.toLowerCase().contains("border_colour") || ops.toLowerCase().contains("border_colour_hover")) {
            try {
                borderColour = Part.readColour(Part.readOption(ops, "border_colour", "#FFFFFF"));
                borderColourHover = Part.readColour(Part.readOption(ops, "border_colour_hover", "#" + Integer.toHexString(borderColour)));
            }
            catch (NumberFormatException e) {
                return recipeMatch.replaceFirst("[Broken Recipe. Invalid Colour Value! Must be hex starting with 0x or # or a red,green,blue value]");
            }
        } else {
            borderColour = -1;
            borderColourHover = -1;
        }
        try {
            int padding = Integer.parseInt(Part.readOption(ops, "padding", "1"));
            leftPad = Integer.parseInt(Part.readOption(ops, "left_pad", String.valueOf(padding)));
            rightPad = Integer.parseInt(Part.readOption(ops, "right_pad", String.valueOf(padding)));
            topPad = Integer.parseInt(Part.readOption(ops, "top_pad", String.valueOf(padding)));
            bottomPad = Integer.parseInt(Part.readOption(ops, "bottom_pad", String.valueOf(padding)));
            spacing = Integer.parseInt(Part.readOption(ops, "spacing", "0"));
        }
        catch (NumberFormatException e) {
            return recipeMatch.replaceFirst("[Broken Image. Invalid padding value! Must be an integer number]");
        }
        StackReference stackRef = StackReference.fromString(stackString);
        if (stackRef == null || (stack = stackRef.createStack()).func_190926_b()) {
            return recipeMatch.replaceFirst("[Broken recipe. Specified Item or Block could not be bound!]");
        }
        if (!JeiHelper.jeiAvailable()) {
            return recipeMatch.replaceFirst("[Broken recipe. The mod JEI (Just Enough Items) is required to display recipes!]");
        }
        final List<IRecipeRenderer> renderers = JeiHelper.getRecipeRenderers(stack);
        if (renderers == null) {
            return recipeMatch.replaceFirst("[Broken recipe. No recipe's were found for " + stackString + "]");
        }
        final MouseIntractable mi = new MouseIntractable(){

            @Override
            public boolean onClick(int mouseX, int mouseY, int button) {
                for (IRecipeRenderer renderer : renderers) {
                    Object ingredient = renderer.getIngredientUnderMouse(mouseX, mouseY);
                    if (!(ingredient instanceof ItemStack)) continue;
                    container.recipeClick((ItemStack)ingredient, button);
                    return true;
                }
                return false;
            }
        };
        container.mouseIntractables.add(mi);
        int lastHeight = 0;
        for (final IRecipeRenderer renderer : renderers) {
            int height = renderer.getHeight() + topPad + bottomPad + spacing;
            int width = renderer.getWidth() + leftPad + rightPad + spacing;
            if (this.finalXPos + width > elementRight) {
                this.finalXPos = elementLeft;
                this.finalYPos = Math.max(nextYLevel, this.finalYPos + lastHeight);
                lastHeight = 0;
            }
            if (height > lastHeight) {
                lastHeight = height;
            }
            Part part = new Part(container){

                @Override
                public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                    int offset;
                    int n = this.container.align == GuiAlign.CENTER ? spacing / 2 : (offset = this.container.align == GuiAlign.RIGHT ? spacing : 0);
                    if (borderColour != -1) {
                        int border = mi.isMouseOver ? borderColourHover : borderColour;
                        this.container.drawColouredRect(xPos + offset, yPos, this.width - spacing, this.height - spacing, 0xFF000000 | border);
                    }
                    renderer.render(this.container.mc, xPos + leftPad + offset, yPos + topPad, mouseX, mouseY);
                    if (GuiHelper.isInRect(xPos, yPos, renderer.getWidth(), renderer.getHeight(), mouseX, mouseY)) {
                        this.container.hoveredRecipe = renderer;
                    }
                    GlStateManager.func_179131_c((float)font.field_78291_n, (float)font.field_78292_o, (float)font.field_78306_p, (float)1.0f);
                }
            };
            part.width = width;
            part.height = height;
            this.finalXPos += part.width;
            parts.add(part);
            mi.parts.add(part);
        }
        this.builtHeight = this.finalYPos - yPos + lastHeight + 1;
        return recipeMatch.replaceFirst("");
    }
}

